#ifndef DEBUG_H
#define DEBUG_H
#include "mbed.h"
#include "pinconfig.h"

class Debug
{
private:
    Serial debug;
    float scan_input_data;
    float scan_input_data_loop;
    bool change;
    int temp_state;
    bool first_time;

    //bool mode[40]; //Dont forget to change elements : 'false' = do nothing in loop, 'true' = do something in loop
    //int temp_mode_data[40];

public:
    Debug(PinName, PinName);
    int ScanInputData(int);        //return int in case of want to check what the input data is
    int ScanInputDataInLoop();  //return int in case of want to check what the input data is
    int Mode();

    //Mode
    int SelectMode(int);
    int Mode1();
    int Mode2();

    //Print
    void PrintListMode();
    void PrintExit() {
        debug.printf("Exit From Debug Mode\n\n");
    }
    void PrintAll(float num) {
        debug.printf("Data is %f\n",num);
    }


    //set
    void setChange() {
        change=false;
    }


    //get
    float getScanInputData() {
        return scan_input_data;
    }
};

#endif