/***********************************
name:   ur_Bertl.h      Version: 3.0
        class Bertl included
author: PE HTL BULME
email:  pe@bulme.at
WIKI:   https://developer.mbed.org/teams/BERTL_CHEL_18/code/ur_Bertl/
description:
        Definition portion of the class ur_Bertl The Robot
        Step wise turns on left and rigth
        int ReturnButtonPressed() added which returns the int value of button pressed 
***********************************/
#include "mbed.h"
#include "const.h"

#ifndef UR_BERTL_H
#define UR_BERTL_H

#define LEFTSENSOR P1_12
#define RIGHTSENSOR P1_13
/********************************************//**
 name:   ur_Bertl.h \n
 version: 3.0 \n
   class Bertl included \n
 author:PE HTL BULME \n
 email: pe@bulme.at \n
 WIKI:  https://developer.mbed.org/teams/BERTL_CHEL_18/code/ur_Bertl/wiki/Homepage \n
 description: 
    Definition and documentation portion of the class ur_Bertl The Robot.
   
***********************************************/
/** 
@code
//
@endcode

Example motor sensor test:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"
 
int main()
{
    ur_Bertl karel(LEFTSENSOR);  // RIGHTSENSOR

    while(true) {
        karel.NibbleLeds(karel.Read());
    }
}
@endcode

Example moving the robot around:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"

int main()
{
    ur_Bertl karel;
    
    while(karel.WaitUntilButtonPressed()){}
    //karel.Move();
    karel.TurnLeft();
    karel.ShutOff();
}
@endcode

Example LEDs:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"

int main()
{
   ur_Bertl karel;
   
   while(karel.WaitUntilButtonPressed()){}

   karel.TurnLedOn(LED_FL1 | LED_FR1);  // see const.h
   wait(1);
   karel.TurnLedOn(0xFF);               // or use hex
   wait(1);
   karel.RGBLed(1,0,0);     // red
   wait(1);
   karel.RGBLed(0,1,0);     // green
   wait(1);
   karel.RGBLed(0,0,1);     // blue
   karel.BlueLedsON();
   karel.NibbleLeds(karel.Read());
   wait(1);
   karel.BlueLedsOFF();
   karel.TurnLedOff(0xFF);
   karel.ShutOff();
} 
@endcode
Example IF/ELSE Commands (update ur_Bertl 2.0 from https://developer.mbed.org/teams/BERTL_CHEL_18/code/ur_Bertl/
@code
/*Sorry, but there are Javascript problems with this code

int main()
{
    ur_Bertl karel;

    while( karel.WaitUntilButtonPressed() ) {}
    if( karel.NextToABeeper()) {
        karel.PickBeeper();
        karel.NibbleLeds(karel.AnyBeeperInBag());   //show number of beepers in bag on 4 yellow Leds
    }
    wait(1);
    if( karel.AnyBeeperInBag() ) {
        karel.PutBeeper();
        karel.NibbleLeds(karel.AnyBeeperInBag());  
    }
    wait(1);
    if( karel.FrontIsClear() )
        karel.Move();
    else
        karel.TurnLeft();

    karel.ShutOff();
}


@endcode
 */
class ur_Bertl
{
protected:
    int beepersInBag;       /**< how many beepers does the robot have in his bag;\n you can show it with: karel.NibbleLeds(karel.AnyBeeperInBag())*/
    char cmd[3];            /**< I2C command */
    int16_t btns;           /**< which button is pressed */
    InterruptIn _interrupt; /**< interrupted used*/
    volatile int _count;    /**< values of motor sensor*/

    /**
    protected methodes for internal purposes only
    */
    void increment();       /**< ISR to increment sensor values of motor */
    bool backIsClear();     /**< don't now for what */
    bool frontButtonPressed();/**< TRUE if a a button on the front of Robot is pressed else FALSE */
    int bottomIsBlack();    /**< check line sensor; returns BCD value */
    void error();           /**< Error: stops the robot and all LEDs are blinking*/

public:
    ur_Bertl();                 /**< default constructor; you have to define constants in config.h such as SPEED, DISTANCE or ANGLE*/
    ur_Bertl(PinName pin);      /**< parameterized constructor; on what pin should the interrupt work; SPEED, DISTANCE or ANGLE have to bee defined in config.h */

    //void Move();                /**< Robot moves one turn as much as the constant DISTANCE; if one of the buttons fire --> Error()*/      
    void Move();                /**< Robot moves one turn as much as the constant DISTANCE; if one of the buttons fire --> Error()*/      
    void TurnLeft();            /**< Robot turns left as much as the constant ANGLE*/      
    void PutBeeper();           /**< if Robot has any Beepers in his bag he can put one or more Beeper; if not --> Error(()*/  
    void PickBeeper();          /**< if Robot stands on a black item he can pick one or more Beeper (max. 15 --> Error()); if not --> Error()*/   
    void TurnOff();             /**<  turnes the robot off */
    bool WaitUntilButtonPressed();  /**< wait until any button is pressed at the robot */
    bool FrontIsClear();        /**< returns a boolean value true if front is free; if not false */ 
    bool NextToABeeper();       /**< returns a boolean value true if the robot is on a black place or line; if not --> false */ 
    bool IsButtonPressed(const int btn); /**< returns true if Button btn is pressed, else false */
    int ReturnButtonPressed();  /**< returns the int value of button pressed */
    int AnyBeeperInBag();       /**< returns an int value (if > 0 equal true) how many beepers in bag; if zero --> false */ 
    void NibbleLeds(int value); /**< methode for the 4 (half byte) yellow LEDs at the back left side; ie. you can show how many beeper a robot has in his bag with: karel.NibbleLeds(karel.AnyBeeperInBag())*/
    void TurnLedOn(int16_t led);/**< turns the specified one or more LEDs ON; description and name in const.h, such as LED_FL1 = 0x01; front LED white */
    void TurnLedOff(int16_t led);/**< turns the specified one or more LEDs OFF; description and name in const.h, such as LED_FL1 = 0x01; front LED white */
    void RGBLed(bool red, bool green, bool blue); /**<RGB Led with red, green and blue component of the Color */
    void BlueLedsOFF();         /**< OFF all blue LEDs which are on the same Port 1_28 */   
    void BlueLedsON();          /**< ON all blue LEDs which are on the same Port 1_28 */   
    int Read();
};
/********************************************//**
 name:   Bertl.h \n
 version: 3.0 \n
 author:PE HTL BULME \n
 email: pe@bulme.at \n
 WIKI:  https://developer.mbed.org/teams/BERTL_CHEL_18/code/ur_Bertl/wiki/Homepage \n
 description: 
    Definition and documentation portion of the class Bertl The Robot.
   
***********************************************/

/** 
@code
//
@endcode

Example motor sensor test:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"
 
int main()
{
    ur_Bertl karel(LEFTSENSOR);  // RIGHTSENSOR

    while(true) {
        karel.NibbleLeds(karel.Read());
    }
}
@endcode

Example follow a line:
@code
#include "mbed.h"
#include "ur_Bertl.h"
#include "const.h"

int main()
{
    Bertl karel;
    
    while(karel.WaitUntilButtonPressed())
    {
        karel.NibbleLeds(karel.GetLineValues());
        switch(karel.GetLineValues())
        {
        case 0x00:
            karel.TurnLeftStep(50);
            break;
        case 0x03: case 0x01: case 0x07:
            karel.TurnLeftStep(20);
            break;
        case 0x0E: case 0x0A: case 0x08:
            karel.TurnRigthStep(20);
            break;
        default:
            karel.Move(20);
            break;
        }
        if(!karel.FrontIsClear())
            karel.TurnLeftStep(1000);
    }
}
@endcode
*/
class Bertl : public ur_Bertl
{
protected:
public:
    //Bertl();                 /**< default constructor; you have to define constants in config.h such as SPEED, DISTANCE or ANGLE*/
    int Move(int move = MOVE);                /**< Robot moves one turn as much as the constant DISTANCE; if one of the buttons fire --> Error()*/      
    int MoveBackwards(int move = MOVE);       /**< Robot moves as much back as the constant DISTANCE; if one of the buttons fire --> Error()*/
    void TurnRigth();           /**< Robot turns rigth as much as the constant ANGLE*/ 
    void TurnLeftStep(int step=STEPTIME);   /**< Robot turns left for a short time defined in STEPTIME */
    void TurnRigthStep(int step=STEPTIME);  /**< Robot turns rigth for a short time defined in STEPTIME */
    uint8_t GetLineValues();    /**< in the lower 4 bit are the values of the line sensor */
    void RGBLed(bool red, bool green, bool blue); /**<RGB Led with red, green and blue component of the Color */
};
#endif