#include "mbed.h"
#include "nRF24L01P.h"

#define BUFFER_SIZE (sizeof(int)*4 + sizeof(float)*3)
#define BAUDR 115200

#define SAVING_START 'S'
#define SAVING_STOP 'E'
#define TRANSFER_START 'T'
#define CHECK_READY 'R'
#define SEND_ACK 'A'

#define NACK 'N'
#define ACK 'A'

Serial pc(USBTX, USBRX);
nRF24L01P rf(p5, p6, p7, p8, p9);
//nRF24L01P rf(p11, p12, p13, p14, p15);
DigitalOut led(LED1);


void send_ack()
{
    char buffer[BUFFER_SIZE];
    buffer[0] = 0x00;
    buffer[1] = SEND_ACK;
    
    rf.write(NRF24L01P_PIPE_P0, buffer, BUFFER_SIZE);    
}

void check_ack()
{
    char buffer[BUFFER_SIZE];
    wait_ms(10);
    if (!rf.readable()) { 
        printf("#%c\n", NACK);
        return;
    }

    rf.read(NRF24L01P_PIPE_P0, buffer, BUFFER_SIZE);
    if (buffer[0] != 0x00 || buffer[1] != SEND_ACK)
        printf("#%c\n", NACK);
    
    printf("#%c\n", ACK);
}

int send_cmd(void)
{
    char buffer[BUFFER_SIZE];
    char c;
    static char last = 0;
    
    c = pc.getc();
    if (c != '#' && last != 1)
        return -1;
    if (c == '#') {
        last = 1;
        return 0;    
    }
    
    last = 0;

    buffer[0] = 0x00;
    buffer[1] = c;
    rf.write(NRF24L01P_PIPE_P0, buffer, BUFFER_SIZE);
    check_ack();
    return 0;
}

void communication(void)
{
    char rxBuf[BUFFER_SIZE+1];
    int bytes;
    int counter, acc_x, acc_y, acc_z;
    float gyro_x, gyro_y, gyro_z;
    
    printf("\n\nReceiving data\n\r");
    while(1) {
        if (pc.readable())
            send_cmd();

        bytes = rf.read(NRF24L01P_PIPE_P0, rxBuf, BUFFER_SIZE);
        if (bytes <= 0)
            continue;

        //send_ack();

        counter = *((int *) rxBuf);
        acc_x = *((int *) &rxBuf[sizeof(int)]);
        acc_y = *((int *) &rxBuf[sizeof(int)*2]);
        acc_z = *((int *) &rxBuf[sizeof(int)*3]);
        gyro_x = *((float *) &rxBuf[sizeof(int)*4]);
        gyro_y = *((float *) &rxBuf[sizeof(int)*4 + sizeof(float)]);
        gyro_z = *((float *) &rxBuf[sizeof(int)*4 + sizeof(float)*2]);
        
        /* transmission start */
        if (counter == -1 && acc_x >= 0) {
            printf("Swimmer id: %d\n", acc_x);
            continue;
        }
        if (counter == -1 && acc_x == -1) {
            printf("End of DATA\n");
            continue;    
        }
        printf("%d %d %d %d %f %f %f\n", counter, acc_x, acc_y, acc_z, gyro_x, gyro_y, gyro_z);
    }
}

int main(void)
{
    pc.baud(BAUDR);
    
    rf.setTransferSize(BUFFER_SIZE);
    rf.setRfOutputPower(NRF24L01P_TX_PWR_ZERO_DB);
    rf.setAirDataRate(NRF24L01P_DATARATE_2_MBPS);
    rf.setReceiveMode();
    rf.enable();
    
    printf("Freq: %d MHz\n\r", rf.getRfFrequency());
    printf("Power: %d dBm\n\r", rf.getRfOutputPower());
    printf("TX Address: %llu\n\r", rf.getTxAddress());
    printf("RX Address: %llu\n\r", rf.getRxAddress());
    
    communication();
}