#include "mbed.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

AnalogIn   controll(p15);
PwmOut     motor(p26);
DigitalOut motor_direction(p25);

void init() {
    // inicializacni sekvence
    int sekvenc[9][4] = {{0,0,0,0},{0,0,0,1},{0,0,1,0},{0,1,0,0},{1,0,0,0},{0,1,0,0},{0,0,1,0},{0,0,0,1},{0,0,0,0}};
    for( int i = 0; i < 9; i++ ) {
       led1 = sekvenc[i][0];
       led2 = sekvenc[i][1];
       led3 = sekvenc[i][2];
       led4 = sekvenc[i][3];   
       wait(0.1);  
    }
}

int main() {
    init();
    motor.period(1/1000);      // 40 kH max
    
    while(1) {
        // kontrola pomoci led
        led1 = (controll > 0.15f) ? 1 : 0;
        led2 = (controll > 0.30f) ? 1 : 0;
        led3 = (controll > 0.45f) ? 1 : 0;
        led4 = (controll > 0.60f) ? 1 : 0;
        
        // ovladani motor
        motor.pulsewidth((1/1000) * (2 * controll));
        motor_direction = ( controll > 0.4 ) ? 1 : 0;
        
        
        wait_ms(50);
    }
}
