// MPU6000 MBED library developed for swimmers

#ifndef _mpu6000_h_
#define _mpu6000_h_
#include "mbed.h"

// MPU6000 class
class MPU6000
{
    // Hardware objects
    SPI& spi;
    DigitalOut cs;
    
    // Public methods
    public:
        MPU6000(SPI& _spi, PinName _cs);
        void regWrite(uint8_t ADDR, uint8_t DATA);
        uint8_t regRead(uint8_t ADDR);
        uint8_t init();
        void valRead(bool device, short int &x, short int &y, short int &z);     
};

#endif

// MPU6000 defines =============================================================

// Read flag
#define READ            0x80

// Device defines 
#define ACCEL           0
#define GYRO            1

// Registers ===================================================================
#define CONFIG          0x1A
#define GYRO_CONFIG     0x1B
#define ACCEL_CONFIG    0x1C
#define MOT_THR         0x1F
#define INT_PIN_CFG     0x37
#define INT_ENABLE      0x38
#define INT_STATUS      0x3A
#define ACCEL_XOUT_H    0x3B
#define ACCEL_XOUT_L    0x3C
#define ACCEL_YOUT_H    0x3D
#define ACCEL_YOUT_L    0x3E
#define ACCEL_ZOUT_H    0x3F
#define ACCEL_ZOUT_L    0x40
#define TEMP_OUT_H      0x41
#define TEMP_OUT_L      0x42
#define GYRO_XOUT_H     0x43
#define GYRO_XOUT_L     0x44
#define GYRO_YOUT_H     0x45
#define GYRO_YOUT_L     0x46
#define GYRO_ZOUT_H     0x47
#define GYRO_ZOUT_L     0x48
#define MOT_DETECT_CTRL 0x69
#define USER_CTRL       0x6A
#define PWR_MGMT_1      0x6B
#define PWR_MGMT_2      0x6C
#define WHO_AM_I        0x75