/*
 * Wifi communication
 *
 * Uses dhcp to obtain the ip and communicates on port 2000
 *
*/
#ifndef __RF_H_
#define __RF_H_

#include "mbed.h"
//#include "WiflyInterface.h"
#define FRAME_HEADER_LEN 6
#define SEND_SIZE 1024

class Wifi {
    public:
        Wifi (PinName tx, PinName rx, PinName cts, PinName reset);
        /*
         * Serves as constructor (we're changing PLL frequency)
         */
        void init(void);
        /*
         * Returns received command (without #), just the one char
         */
        int getCmd(char* cmd_header, char* cmd_data);
        
        /*
         * Sends one char to wifly
         */
        void sendByte(char byte);
        
        /*
         * Sends one char to wifly
         */
        char readByte(void);
        
        /*
        * Format: (int) -1 (int) -1 (int) swimmer_id
        *   many times (int) count 3*(short) acc 3*(float)gyro
        *         (int) -1 (int) -1    up to 1023 zeros   
        */
        //int sendFile(const char *fname, int swimmer_id);
        int sendFile(const char *fname);
        bool readable(void);
        void sendAck(void);
        void sendNack(void);
        void sendFail(void);
        int waitForAck(void);

    private:
        Serial wifi_;
        int in_buf;
        char buffer[SEND_SIZE];
        void bufferSend(size_t size);
        int bufferSendVerify(char byte); 
        int bufferFlush(void);
};

#endif