#include <mbed.h>

void itoa(int num, int type, char *buf)
{
    char *c = buf;
    char *start, *stop;
    int base = 10, digit;
    if (type == 'd' && num < 0) {
        *c++ = '-';
        num = -num;
    }

    if (type == 'x') {
        base = 16;
        *c++ = '0';
        *c++ = 'x';
    }
    start = c;

    /* create string from number */
    do {
        digit = num % base;
        *c++ = digit > 9 ? 'A' + digit - 10 : '0' + digit;
    } while (num /= base);

    *c = '\0';
    stop = c - 1;

    /* string is reversed, reverse it to the correct form */
    while (start < stop) {
        char tmp = *start;
        *start++ = *stop;
        *stop-- = tmp;
    }
}

/*
 * Copy value of size bytes (use sizeof(type)) to buffer
 */
void toBytes(char *buffer, void *value, size_t size)
{
    int i;
    
    for (i = 0; i < size; i++)
        buffer[i] = *((char *) value + i);
}