#include "mbed.h"
#include    "BNO055.h"

Serial pc(USBTX,USBRX);
I2C    i2c(D14, D15);   // SDA, SCL
BNO055 imu(i2c, D12);  // Reset =D7, addr = BNO055_G_CHIP_ADDR, mode = MODE_NDOF <- as default

BNO055_ID_INF_TypeDef bno055_id_inf;
BNO055_EULER_TypeDef  euler_angles;

int main()
{
    pc.printf("Bosch Sensortec BNO055 test program on " __DATE__ "/" __TIME__ "\r\n");
    if (imu.chip_ready() == 0)
    {
         pc.printf("Bosch BNO055 is NOT avirable!!\r\n");
    }
    
    imu.read_id_inf(&bno055_id_inf);
    pc.printf("CHIP:0x%02x, ACC:0x%02x, MAG:0x%02x, GYR:0x%02x, , SW:0x%04x, , BL:0x%02x\r\n",
        bno055_id_inf.chip_id, bno055_id_inf.acc_id, bno055_id_inf.mag_id,
        bno055_id_inf.gyr_id, bno055_id_inf.sw_rev_id, bno055_id_inf.bootldr_rev_id);
    
    while(1)
    {
        imu.get_Euler_Angles(&euler_angles);
        pc.printf("Heading:%+6.1f [deg], Roll:%+6.1f [deg], Pich:%+6.1f [deg]\r\n",
            euler_angles.h, euler_angles.r, euler_angles.p);
        wait(0.5);
    }
}

