//Ben Keegan, Mitch Bond, Nick Dilleumber, Rixon Fletcher
//ES202 Principles of Mechatronics
//Autonomous Vehicle Project
//26 APR 2015
//Edit: Comments Revised 28 APR 2015

#include "mbed.h"
#include "Servo.h"
#include "Motor.h"
#include "TCS3472_I2C.h"

//Actuators and Ultrasonic Sensor Pins
Motor M(p26, p29, p30);
Servo S(p23);
AnalogIn coke(p20); // sets analog in to pin 20
//Color Sensor Pins
PwmOut LB(p22); // PWM out signal to power LED on the sensor
TCS3472_I2C rgb_sensor( p9, p10 ); // Establish RGB sensor object
//IR Sensor Pins
AnalogIn photod1(p15);
AnalogIn photod2(p16);
AnalogIn photod3(p17);

//Serial pc(USBTX,USBRX); // Establish serial connection with computer

float volt = 0.0; // Variable used for ultrasonic sensor analog value
int distance = 100.0; //Initialize distance value, was initially a condition for the while loop, which is why it is 100
float cof[2] = {489.1001, 2.0247}; // coefficients from matlab calibration for ultrasonic distance equation
int count = 0;// Initialize ultrasonic fail-safe counter variable
int there = 0;// Initialize loop terminating variable for when the vehicle reaches the desired location

int main()
{
    rgb_sensor.enablePowerAndRGBC(); // Enable RGB sensor
    rgb_sensor.setIntegrationTime(100); // Set integration time of sensor
    //pc.baud(921600); // Set Baud rate of serial connection
    //pc.format(8, SerialBase::None, 1);
    int rgb_data[4]; // declare a 4 element array to store RGB sensor readings
    float PWMbrightness = 0.75; // declare a float specifying brightness of LED (between 0.0 and 1.0)
    
    float r; //photodiode 1
    float m; //photodiode 2
    float l; //photodiode 3
    int mult=1000; //Multiplier to amplify signal and make numbers easier to work with

    S= 0.63;// Turn servo to straighten front wheels
    wait(0.1);
    M.speed(0);//Ensure Motors are stopped
    
    while(!there) {// While not at the desired location
        volt = coke;// Variable equal to read-in analog value from ultrasonic sensor
        distance = floor(cof[0]*pow(volt,1) + cof[1]); // determines distance based on calibration coefficients
        
        r=mult*photod1.read(); //variable for right photodiode analog value
        m=mult*photod2.read(); //variable for middle photodiode analog value
        l=mult*photod3.read();//variable for left photodiode analog value
        
        LB = PWMbrightness; // set brightness of sensor LED
        rgb_sensor.getAllColors( rgb_data ); // read the sensor to get red, green, and blue color data along with overall brightness
        //int unf = rgb_data[0]; //Unfiltered light value
        int red = rgb_data[1]; //Red = r data value from rgb sensor
        int green = rgb_data[2];//Green = g data value from rgb sensor
        int blue = rgb_data[3];//Blue = b data value from rgb sensor
        //pc.printf("%d %d %d\n",red, green, blue);
        // Print data to serial port
        //pc.printf( "unfiltered: %d, red: %d, green: %d, blue: %d \n", rgb_data[0], rgb_data[1], rgb_data[2], rgb_data[3]);
        M.speed(-0.2);//Power motors to make vehicle go forward, reverse due to orientation of the motor
        
        if (red > 150 && green < 100){ //If rgb sensor detects values corresponding to red zone
            S = 0.34;// Turn front wheels right
            M.speed(0.25);//Set vehicle in reverse for 0.5 seconds
            wait(.5);
            S= 0.84;//Turn front wheels left
            M.speed(-0.25);//Drive forward
            
            //pc.printf("Turn Left\n");
        }
        else if(green > 200){ //If rgb sensor detects values corresponding to green zone
            S = 0.84; //Turn front wheels left
            M.speed(0.25); //Drive backwards for 0.5 seconds
            wait(0.5);
            S= 0.34; //Turn front  wheels right
            M.speed(-0.25); //Drive forward 

            //pc.printf("Turn Right\n");
            }
        else {// Else, vehicle is in blue zone. /*(green-red)<50 && (blue-green)<50)*/
            //pc.printf("Go Straight\n");
            S= 0.63; //Turn wheels back to center in order to drive straight
        }
        
        if (count > 10000){ //After 10000 counts, to mitigate a preemptive stop before getting close to the beacon
            if (distance < 17){ //If ultrasonic sensor detects 17 inches
            /*The sensor was very inconsistent even after multiple calibration attempts and 3 inches from the beacon/wall 
            ended up corresponding to a reading of 17*/
                M.speed(0); //Stop vehicle
                if (r > 200){ //If right photodiode reads highm make adjustments to face the lighthouse
                /*Based on the course, we knew the vehicle would either face towards the beacon, or to the left of it,
                 thus exposing the right photodiode to the IR source, so if the right photodiode gave a conditioned signal 
                 reading above 200, the vehicle would make adjustments to better face the beacon.*/
                    S = 0.84;//Turn front wheels left
                    M.speed(0.25);//Drive Backwards for 0.5 seconds
                    wait(0.5);
                    S= 0.34;//Turn wheels right
                    M.speed(-0.25);//Drive forward for a very small amount of time (0.05 seconds)
                    wait(0.05);
                    M.speed(0); //Stop Vehicle
                }
                there = 1; //Vehicle is at location, terminator variable to disatisfy while loop condition in order to break out of the loop
            }
        }
        count +=1; //Increment counting variable by 1 with each iteration of the while loop, used for delayed use of ultrasonic sensor
    }// end while
    M.speed(0); //Ensure vehicle is stopped
    //pc.printf("Stop/n");
} // end main