/*
 * cSPI.cpp
 *
 *  Created on: 5 avr. 2016
 *      Author: clement
 */

#include "cSPI.h"
#include "cMatrice.h"

DigitalOut _cs(p14);
SPI _spi(p11,p12, p13);


// CONSTRUCTEURS

cSPI::cSPI()
{
    _freq = 0;
    _mode = 0;
    _bits = 0;
}

// DESTRUCTEUR

cSPI::~cSPI()
{

}
// GETTERS

unsigned int cSPI::getFrequence()
{
    return _freq;
}

unsigned int cSPI::getMode()
{
    return _mode;
}

unsigned char cSPI::getBits()
{
    return _bits;
}

// SETTERS

void cSPI::setFrequence(unsigned int freq)
{
    _freq = freq;
}

void cSPI::setMode(unsigned int mode)
{
    _mode = mode;
}

void cSPI::setBits(unsigned char bits)
{
    _bits = bits;
}

//Méthode d'initialisation de la liaison SPI
//Entrées: fréquence: valeur de la fréquence de la liaison
//Sorties: aucune.
void cSPI::initSPI(unsigned int frequence)
{
    _cs = 0;
    wait_ms(1);
    _spi.frequency(frequence);
    wait_ms(1);
    _cs = 1;
}

//Méthode de rafraîchissemnt des matrices
//Entrées: mat: matrice à afficher
//Sorties: aucune.
void cSPI::envoyerMatrice(cMatrice & mat)
{
    _cs = 0;
    wait_ms(1);
    for(unsigned char i = 0; i < mat.getCol(); i++) {
        for(unsigned char j = 0; j < mat.getLig()/2; j ++) {
            _spi.write(mat.getValTab(i, j));
            if(mat.getValTab(i, j)) {
            } else {
            }
        }
    }
    for(unsigned char i = 0; i < mat.getCol(); i++) {
        for(unsigned char j = mat.getLig()/2; j < mat.getLig(); j ++) {
            _spi.write(mat.getValTab(i, j));
            if(mat.getValTab(i, j)) {
            } else {
            }
        }
    }
    wait_ms(1);
    _cs = 1;

}

//Méthode de configuration du nombre de matrices de LEDs en DaisyChain
//Entrées: nb: entier qui correspond au nombre de matrices
//Sorties: aucune.
void cSPI::setNbMatrice(unsigned int nb)
{
    _cs = 0;
    wait_ms(1);
    _spi.write('%');
    _spi.write(nb);
    wait_ms(1);
    _cs = 1;
}
