#include "cMatrice.h"
#include <algorithm>

// CONSTRUCTEURS
//Constructeur par défaut
cMatrice::cMatrice()
{

}

//Constructeur qui alloue dynamiquement la mémoire pour lamatrice
cMatrice::cMatrice(unsigned char c, unsigned char l)
{
    _lig = l;
    _col = c;
    _matrice = new unsigned char*[_lig];
    for(unsigned char i = 0; i < _lig; i++) {
        _matrice[i] = new unsigned char[_col];
    }
    clear();
    decalage = 1;
}

// DESTRUCTEUR
cMatrice::~cMatrice()
{
    for(unsigned char i = 0; i < _lig; i++) {
        delete[] _matrice[i];
        delete[] _matrice;
    }
}

// GETTER
unsigned char cMatrice::getValTab(unsigned char l, unsigned char c)
{
    return _matrice[l][c];
}

unsigned char cMatrice::getCol()
{
    return _col;
}

unsigned char cMatrice::getLig()
{
    return _lig;
}

cForme* cMatrice::get_pForme()
{
    return _pForme;
}
// SETTER

void cMatrice::setCol(unsigned char c)
{
    _col = c;
}

void cMatrice::setLig(unsigned char l)
{
    _lig = l;
}
void cMatrice::setValTab(unsigned char l, unsigned char c, unsigned char coul)
{
    _matrice [l][c] = coul;
}

//Méthode qui associe la nouvelle pièce crée à la matrice, via un pointeur
//Entrées:
//  f: Forme à afficher
//  c: Couleur
//Sorties: aucune.
void cMatrice::afficherForme(cForme* f, unsigned char c)
{
    //On pointe sur la pièce
    _pForme = f;
    // Changement de couleur des Leds
    for (int i = 0; i < 4; i++) {
        _pForme->getLed(i).setCouleur(c);
        _matrice[_pForme->getLed(i).getPositionX()][_pForme->getLed(i).getPositionY()] = c;
    }
}


//Méthode de nettoyage de la matrice, passage à 0 de la valeur de chaque LED
//Entrées: aucune.
//Sorties: aucune.
void cMatrice::clear()
{
    for(unsigned char i = 0; i < _col; i++) {
        for(unsigned char j = 0; j < _lig; j++) {
            _matrice[i][j] = LED_NOIR;
        }
    }
    //On affiche le coin en haut à gauche de la matrice pour se repérer
    _matrice[0][0] = LED_ROUGE;
}

//Méthode qui va actualiser les LEDs de la pièce après mouvement
//Entrées: aucune.
//Sorties: aucune.
void cMatrice::updateMatrice()
{
    // On éteint les leds de la pièce
    for (int i = 0; i < 4; i++) {
        _matrice[_pForme->getLed(i).getOldPositionX()][_pForme->getLed(i).getOldPositionY()] = LED_NOIR;
    }
    // Affichage de la nouvelle position
    afficherForme(_pForme, _pForme->getLed(0).getCouleur());
}

//Méthode qui crée le message d'accueil en début de jeu "Move your Tetris",
//et afffiche les 3 premiers caractères.
//Entrées: aucune.
//Sorties: aucune.
void cMatrice::messageAccueil()
{
    int i, j;
    //On efface tout le tableau 2D qui ca contenir le message
    for(i=0; i<8 ; i++) {
        for(j=0; j<67; j++) {
            matriceMessage[i][j]= LED_NOIR;
        }
    }
    unsigned char coul;
    j=0;
    //Le mot "Move" est coloré en rouge
    coul = LED_ROUGE;
    //M
    for(i = 1; i < _col -1; i++) {
        matriceMessage[i][j] = coul;
    }
    j++;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[5][j] = coul;
    j++;
    for(unsigned char i = 1; i < _col -1; i++) {
        matriceMessage[i][j] = coul;
    }
    j++;
    j++;
    //o
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    j++;
    j++;
    //v
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    j++;
    //e
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[4][j] = coul;
    j++;
    j++;
    //Le mot "your" est coloré en vert
    coul = LED_VERT;
    //y
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    j++;
    //o
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    j++;
    j++;
    //u
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    j++;
    //r
    matriceMessage[1][j] = coul;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[3][j] = coul;
    j++;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[3][j] = coul;
    j++;
    j++;
    //Le mot "Tetris" est coloré en bleu foncé
    coul = LED_BLEU_FONCE;
    //T
    matriceMessage[6][j] = coul;
    j++;
    matriceMessage[6][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    matriceMessage[5][j] = coul;
    matriceMessage[6][j] = coul;
    j++;
    matriceMessage[6][j] = coul;
    j++;
    matriceMessage[6][j] = coul;
    j++;
    j++;
    //e
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[4][j] = coul;
    j++;
    j++;
    //t
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[4][j] = coul;
    j++;
    j++;
    //r
    matriceMessage[1][j] = coul;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[3][j] = coul;
    j++;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[3][j] = coul;
    j++;
    j++;
    //i
    matriceMessage[1][j] = coul;
    matriceMessage[2][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    j++;
    //s
    matriceMessage[1][j] = coul;
    matriceMessage[4][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[1][j] = coul;
    matriceMessage[3][j] = coul;
    matriceMessage[5][j] = coul;
    j++;
    matriceMessage[2][j] = coul;
    matriceMessage[5][j] = coul;
    //On "colle" les 16 premières colonnes du message sur la matrice
    for(unsigned char i = 0; i < _col; i++) {
        for(unsigned char j = 0; j < _lig; j++) {
            _matrice[i][j] = matriceMessage[i][j];
        }
    }
}

//Méthode de décalage vers le haut du message d'accueil
//Entrées: aucune.
//Sorties: aucune.
void cMatrice::decalerMatrice()
{
    for(unsigned char i = 0; i < _col; i++) {
        for(unsigned char j = 0; j < _lig; j++) {
            _matrice[i][j] = matriceMessage[i][j+decalage];
        }
    }
    decalage++;
}