#include "cCollision.h"

cCollision::cCollision()
{

}

cCollision::~cCollision()
{

}

//  Descritpion: Détecte du bord droit de la matrice
//Entrées: f: pièce à tester, m: matrice à tester
//  Sortie : booléen
//           False : Pas de collision
//           True Collision
bool cCollision::bordDroit(cForme &f)
{
    for(unsigned char j = 0; j < 4; j++) { // On parcourt les leds
        if(f.getLed(j).getPositionX() == 7) {  // Pour chaque led, si elle est en bout de colonne (droite)
            return true;    // COLLISION PRESENTE
        }
    }
    return false;   // PAS DE COLLISION
}

//  Descritpion: Détecte du bord gauche de la matrice
//Entrées: f: pièce à tester, m: matrice à tester
//  Sortie : booléen
//           False : Pas de collision
//           True Collision
bool cCollision::bordGauche(cForme &f)
{
    for(unsigned char j = 0; j < 4; j++) { // On parcourt les leds
        if(f.getLed(j).getPositionX() == 0) {  // Pour chaque led, si elle est en bout de colonne (gauche)
            return true;    // COLLISION PRESENTE
        }
    }
    return false;   // PAS DE COLLISION
}

//  Descritpion: Détecte du bas de la matrice
//Entrées: f: pièce à tester, m: matrice à tester
//  Sortie : booléen
//           False : Pas de collision
//           True Collision
bool cCollision::bordBas(cForme &f, cMatrice &m)
{
    bool res = false;
    for(unsigned char j = 0; j < 4; j++) { // On parcourt les leds
        if(f.getLed(j).getPositionY() == m.getLig() - 1) {  // Pour chaque led, si elle est en bout de colonne (Bas)
            res = true;    // COLLISION PRESENTE
        }
    }
    return res;   // PAS DE COLLISION
}


//  Descritpion: Détection d'une pièce sous la pièce courante
//Entrées: f: pièce à tester, m: matrice à tester
//  Sortie : booléen
//           False : Pas de collision
//           True Collision
bool cCollision::pieceBas(cForme &f, cMatrice &m)
{
    unsigned char test = 1;
    for(unsigned char i = 0; i < 4; i++) {
        if(m.getValTab(f.getLed(i).getPositionX(), f.getLed(i).getPositionY() + 1) != LED_NOIR) { // SI la led sous la led courante n'est pas noire
            test = 1;
            for(unsigned char j = 0; j < 4; j++) {
                if(f.getLed(i).getPositionY() + 1 == f.getLed(j).getPositionY() && f.getLed(i).getPositionX() == f.getLed(j).getPositionX()) {
                    test = 0;
                }
            }
            if(test == 1) {
                return true;
            }
        }
    }
    return false;
}

//  Descritpion: Détection d'une pièce à gauche de la pièce courante
//Entrées: f: pièce à tester, m: matrice à tester
//  Sortie : booléen
//           False : Pas de collision
//           True Collision
bool cCollision::pieceGauche( cForme &f, cMatrice &m)
{
    unsigned char test = 1;
    for(unsigned char i = 0; i < 4; i++) {
        if(m.getValTab(f.getLed(i).getPositionX() - 1, f.getLed(i).getPositionY()) != LED_NOIR) { // SI la led sous la led courante n'est pas noire
            test = 1;
            for(unsigned char j = 0; j < 4; j++) {
                if(f.getLed(i).getPositionX() - 1 == f.getLed(j).getPositionX() && f.getLed(i).getPositionY() == f.getLed(j).getPositionY()) {
                    test = 0;
                }
            }
            if(test == 1) {
                return true;
            }
        }
    }
    return false;
}

//  Descritpion: Détection d'une pièce à droite de la pièce courante
//Entrées: f: pièce à tester, m: matrice à tester
//  Sortie : booléen
//           False : Pas de collision
//           True Collision
bool cCollision::pieceDroite(cForme &f, cMatrice &m)
{
    unsigned char test = 1;
    for(unsigned char i = 0; i < 4; i++) {
        if(m.getValTab(f.getLed(i).getPositionX() + 1, f.getLed(i).getPositionY()) != LED_NOIR) { // SI la led sous la led courante n'est pas noire 
            test = 1;
            for(unsigned char j = 0; j < 4; j++) {
                if(f.getLed(i).getPositionX() + 1 == f.getLed(j).getPositionX() && f.getLed(i).getPositionY() == f.getLed(j).getPositionY()) {
                    test = 0;
                }
            }
            if(test == 1) {
                return true;
            }
        }
    }
    return false;
}