#ifndef CSPI_H_
#define CSPI_H_

#include "mbed.h"
#include "cMatrice.h"

// Définition de la classe cSPI
// Classe de gestion de la liaison SPI (initialisation et envoi de la matrice).

class cSPI {
private:
    unsigned int _freq;
    unsigned char _mode;
    unsigned char _bits;

public:
    // CONSTRUCTEURS
    cSPI();
    // DESTRUCTEUR
    ~cSPI();
    // GETTERS
    unsigned int getFrequence();
    unsigned int getMode();
    unsigned char getBits();

    // SETTERS
    void setFrequence(unsigned int freq);
    void setMode(unsigned int mode);
    void setBits(unsigned char bits);
    // METHODES
    void initSPI(unsigned int frequence);
    void envoyerMatrice(cMatrice &);
    void setNbMatrice(unsigned int nb);
};

#endif /* CSPI_H_ */
