#ifndef CFORME_H
#define CFORME_H

#include "cLed.h"

// Définition de la classe cForme
// Classe qui définit les caractéristiques d'une pièce

class cForme {

protected:
	unsigned char _orientation; // 4 orientations : rotation de 90° --> de 1 à 4
	//Position actuelle du point de référence:
	//C'est l'axe de la pièce pour les rotations
	unsigned char _positionX;
	unsigned char _positionY;
	//Ancienne position  du point de référence
	unsigned char _oldPositionX;
	unsigned char _oldPositionY;
	unsigned char _typeForme;//0=ligne, 1=carré, 2=Z, 3=T, 4=L
	//Toute forme est composée de 4 LEDs
	cLed _Leds[4]; // LEDS
private:

public:
	// CONSTRUCTEURS
	cForme();
	// DESTRUCTEURS
	virtual ~cForme();
	// GETTERS
	unsigned char getOrientation();
	unsigned char getPositionX();
	unsigned char getPositionY();
	unsigned char getOldPositionX();
	unsigned char getOldPositionY();
	cLed &getLed(unsigned char i);
	//////////////////////////////////////////////
	unsigned char getTypeForme();
	// SETTERS
	void setOrientation(unsigned char orientation);
	void setPositionX(unsigned char x);
	void setPositionY(unsigned char y);
	void setOldPositionX(unsigned char);
	void setOldPositionY(unsigned char);
	// METHODES
	void deplacementBas();
	void deplacementDroite();
	void deplacementGauche();
	// METHODES VIRTUELLES
	virtual void rotationHoraire();

};

#endif
