#include "mbed.h"
#include "cJeu.h"
#include "glibr.h"
#include "cmsis_os.h"


//Instanciation d'un capteur de mouvement
//Paramètres: broches I2C SDA, SCL
glibr GSensor(p9,p10);

osPoolDef(mpool, 16, message_t);
osPoolId  mpool;

osMessageQDef(queue, 16, message_t);
osMessageQId  queue;

//Fonction de détection des mouvements, appelé par le 2e thread
void detectionMouvement(void const *args)
{
    Serial pc(USBTX, USBRX);
    //Initialisation du capteur
    if ( GSensor.ginit() ) {
        pc.printf("APDS-9960 initialization complete\n\r");
    } else {
        pc.printf("Something went wrong during APDS-9960 init\n\r");
    }

    //Démarrage du moteur de détection des mouvements
    if ( GSensor.enableGestureSensor(true) ) {
        pc.printf("Gesture sensor is now running\n\r");
    } else {
        pc.printf("Something went wrong during gesture sensor init!\n\r");
    }
    while(1) {
        //Si un mouvement est détecté
        if(GSensor.isGestureAvailable()) {
            message_t *message = (message_t*)osPoolAlloc(mpool);
            message->val = 0;
            //On lit le mouvement détecté et on associe un nombre
            switch ( GSensor.readGesture() ) {
                case DIR_UP:
                    message->val = 1;
                    break;
                case DIR_DOWN:
                    message->val = 2;
                    break;
                case DIR_LEFT:
                    message->val = 3;
                    break;
                case DIR_RIGHT:
                    message->val = 4;
                    break;
                case DIR_NEAR:
                    break;
                case DIR_FAR:
                    break;
                default: {
                }
            }
            //On ajoute la valeur du mouvement à la queue
            osMessagePut(queue, (uint32_t)message, osWaitForever);
            osDelay(10);
        }
    }
}


int main()
{
    // Création du 2e thread pour la détection de mouvement
    Thread thread(detectionMouvement);
    // Cération de la Message Queue, pour transmission de la valeur du mouvement détecté
    mpool = osPoolCreate(osPool(mpool));
    queue = osMessageCreate(osMessageQ(queue), NULL);
    // Instanciation d'un jeu, sur une matrice de 8 colonnes sur 16 lignes
    cJeu* jeu = new cJeu(8,16);
    // Initialisation des réglages principaux
    jeu->initialiser();
    // Affectation des pointeurs vers la queue
    jeu->setQueue(&queue, &mpool);  
    // On lance le jeu
    jeu->nouvelleManche();
    // Fin du jeu ==> Destruction de l'espace pointé
    delete jeu; 
}
