#ifndef JEU_H
#define JEU_H

#include "cMatrice.h"
#include "cCarre.h"
#include "cZed.h"
#include "cEl.h"
#include "cTe.h"
#include "cLigne.h"
#include "cCollision.h"
#include "cSPI.h"
#include "rtos.h"
#include "cmsis_os.h"
#define START_THREAD 1

//Déclaration de la classe cJeu, classe principale du système

//structure pour la Message Queue
typedef struct {
    int val;
} message_t;

class cJeu
{
    // ATTRIBUTS
    private:
    cMatrice *_mat;
    cForme *_ptrForme;
    cSPI _spi;
    unsigned char _score;
    unsigned char _detec;
    osMessageQId* _queue ;
    osPoolId* _pool;
    public:
    // CONSTRUCTEURS
    cJeu();
    cJeu(unsigned char, unsigned char);
    // DESTRUCTEUR
    ~cJeu();
    // SETTERS
    void set_matrice(cMatrice *mat);
    void set_score(unsigned char sc);
    void setDetec(unsigned char);
    void setQueue(osMessageQId*, osPoolId*); 
    // GETTERS
    cMatrice* get_matrice();
    unsigned char get_score();
    unsigned char *getDetec();
    // METHODES
    void initialiser();
    void nouvellePiece();
    unsigned char ligneComplete();
    void nouvelleManche();
    bool partieEnCours();
    void fin();
    void afficherScore();
};

#endif //JEU_H