
#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "rtos.h"

//Create class for RGB LED with 3 PWM out;
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red, float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};


RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}

void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}


//-----------------------------------------------------
DigitalOut led1(LED1);                 // MBED Led 1
DigitalOut led2(LED2);                 // MBED Led 2
RGBLed myLED(p23,p24,p25);             // RGB PWM pins
uLCD_4DGL LCD(p9,p10,p11);             // serial tx, serial rx, reset pin
RawSerial bluemod(p28,p27);            // bluetooth adafruit serial port
SDFileSystem sd(p5, p6, p7, p8, "sd"); // SDcard reader
AnalogOut DACout(p18);                 // Speaker Analog Out
wave_player waver(&DACout);            // Creates wave player at same address


// mutex to make the lcd lib safe
Mutex lcd_mutex;

Thread thread1;
Thread thread2;
Thread thread3;

// Thread 5
// RGB LED

void led_thread()
{
    while(true) {
        char bred=0;
        char bgreen=0;
        char bblue=0;    
        lcd_mutex.lock();     // thread loop
        bred = 0.5 + (rand() % 11)/20.0;
        bgreen = 0.5 + (rand() % 11)/20.0;
        bblue = 0.5 + (rand() % 11)/20.0;
        myLED.write(bred, bgreen, bblue);
        lcd_mutex.unlock();
        Thread::wait(1667);    // wait 1.5s
    }
}

void led_thread1() {
    while (true) {
        char bred=0;
        char bgreen=0;
        char bblue=0;
        while(1) {
            if(bluemod.readable()) {
                lcd_mutex.lock();
                if (bluemod.getc()=='!') {
                    if (bluemod.getc()=='C') { // color data packet
                        bred = bluemod.getc(); // RGB color values
                        bgreen = bluemod.getc();
                        bblue = bluemod.getc();
                        if (bluemod.getc()==char(~('!' + 'C' + bred + bgreen + bblue))) { //checksum OK?
                            myLED.write(bred/255.0, bgreen/255.0, bblue/255.0); // send new color to RGB LED PWM outputs

                        }
                    }
                }
            lcd_mutex.unlock();
            }
          Thread::wait(1000);// wait 1s
        }
    }
}

void waveplayer_thread() {
    while (true) {
        FILE *wave_file;
        printf("\n\n\nHello, wave world!\n");
        wave_file=fopen("/sd/sample.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(1500); // wait 0.5s
    }
}

void lcd_thread() {
    while(true) {
        lcd_mutex.lock();
        LCD.filled_circle(32,65,25, 0x000000);
        LCD.circle(65,65,30,0xFF00FF);
        LCD.filled_circle(97,65,25, 0xFF0000);
        lcd_mutex.unlock();
        Thread::wait(1500); // wait 0.5s
    }
}

int main() {
    lcd_mutex.lock();
    LCD.cls();
    LCD.background_color(BLACK);
    LCD.baudrate(3000000);
    lcd_mutex.unlock();

    thread1.start(led_thread1);   //start RGB thread
    thread2.start(waveplayer_thread);     //start LCD thread
    thread3.start(lcd_thread);  //start speaker thread


    while (true) {
        led1 = !led1;
        lcd_mutex.lock();
        LCD.filled_circle(97,65,25, 0x000000);
        LCD.circle(65,65,30,0xFF00FF);
        LCD.filled_circle(32,65,25, 0x0000FF);
        lcd_mutex.unlock();

        Thread::wait(1000);
    }
}
