// 16 * 8 digital font
static const uint8_t digitals[] = {
    0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00, // 0
    0x00, 0x18, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00, 0x00, 0x00, 0x00, // 1
    0x00, 0x3E, 0x63, 0x63, 0x63, 0x06, 0x06, 0x0C, 0x18, 0x30, 0x63, 0x7F, 0x00, 0x00, 0x00, 0x00, // 2
    0x00, 0x3E, 0x63, 0x63, 0x06, 0x1C, 0x06, 0x03, 0x03, 0x63, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00, // 3
    0x00, 0x06, 0x0E, 0x1E, 0x36, 0x36, 0x66, 0x66, 0x7F, 0x06, 0x06, 0x1F, 0x00, 0x00, 0x00, 0x00, // 4
    0x00, 0x7F, 0x60, 0x60, 0x60, 0x7C, 0x76, 0x03, 0x03, 0x63, 0x66, 0x3C, 0x00, 0x00, 0x00, 0x00, // 5
    0x00, 0x1E, 0x36, 0x60, 0x60, 0x7C, 0x76, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x00, 0x00, 0x00, 0x00, // 6
    0x00, 0x7F, 0x66, 0x66, 0x0C, 0x0C, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, // 7
    0x00, 0x3E, 0x63, 0x63, 0x63, 0x36, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x3E, 0x00, 0x00, 0x00, 0x00, // 8
    0x00, 0x1C, 0x36, 0x63, 0x63, 0x63, 0x37, 0x1F, 0x03, 0x03, 0x36, 0x3C, 0x00, 0x00, 0x00, 0x00, // 9
};

// SmallFont.c 
// Font Size    : 8x12
// Memory usage : 1144 bytes
// # characters : 95

static const uint8_t SmallFont[]={         
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // <Space>
0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x00,0x00, // !
0x00,0x28,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // "
0x00,0x00,0x28,0x28,0xFC,0x28,0x50,0xFC,0x50,0x50,0x00,0x00, // #
0x00,0x20,0x78,0xA8,0xA0,0x60,0x30,0x28,0xA8,0xF0,0x20,0x00, // $
0x00,0x00,0x48,0xA8,0xB0,0x50,0x28,0x34,0x54,0x48,0x00,0x00, // %
0x00,0x00,0x20,0x50,0x50,0x78,0xA8,0xA8,0x90,0x6C,0x00,0x00, // &
0x00,0x40,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '
0x00,0x04,0x08,0x10,0x10,0x10,0x10,0x10,0x10,0x08,0x04,0x00, // (
0x00,0x40,0x20,0x10,0x10,0x10,0x10,0x10,0x10,0x20,0x40,0x00, // )
0x00,0x00,0x00,0x20,0xA8,0x70,0x70,0xA8,0x20,0x00,0x00,0x00, // *
0x00,0x00,0x20,0x20,0x20,0xF8,0x20,0x20,0x20,0x00,0x00,0x00, // +
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x80, // ,
0x00,0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x00,0x00,0x00, // -
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00, // .
0x00,0x08,0x10,0x10,0x10,0x20,0x20,0x40,0x40,0x40,0x80,0x00, // /
0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // 0
0x00,0x00,0x20,0x60,0xA0,0x20,0x20,0x20,0x20,0xF8,0x00,0x00, // 1
0x00,0x00,0x70,0x88,0x88,0x10,0x20,0x40,0x80,0xF8,0x00,0x00, // 2
0x00,0x00,0x70,0x88,0x08,0x30,0x08,0x08,0x88,0x70,0x00,0x00, // 3
0x00,0x00,0x10,0x30,0x50,0x50,0x90,0x78,0x10,0x18,0x00,0x00, // 4
0x00,0x00,0xF8,0x80,0x80,0xF0,0x08,0x08,0x88,0x70,0x00,0x00, // 5
0x00,0x00,0x70,0x90,0x80,0xF0,0x88,0x88,0x88,0x70,0x00,0x00, // 6
0x00,0x00,0xF8,0x90,0x10,0x20,0x20,0x20,0x20,0x20,0x00,0x00, // 7
0x00,0x00,0x70,0x88,0x88,0x70,0x88,0x88,0x88,0x70,0x00,0x00, // 8
0x00,0x00,0x70,0x88,0x88,0x88,0x78,0x08,0x48,0x70,0x00,0x00, // 9
0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x20,0x00,0x00, // :
0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x20,0x20,0x00, // ;
0x00,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x00,0x00, // <
0x00,0x00,0x00,0x00,0xF8,0x00,0x00,0xF8,0x00,0x00,0x00,0x00, // =
0x00,0x40,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x40,0x00,0x00, // >
0x00,0x00,0x70,0x88,0x88,0x10,0x20,0x20,0x00,0x20,0x00,0x00, // ?
0x00,0x00,0x70,0x88,0x98,0xA8,0xA8,0xB8,0x80,0x78,0x00,0x00, // @
0x00,0x00,0x20,0x20,0x30,0x50,0x50,0x78,0x48,0xCC,0x00,0x00, // A
0x00,0x00,0xF0,0x48,0x48,0x70,0x48,0x48,0x48,0xF0,0x00,0x00, // B
0x00,0x00,0x78,0x88,0x80,0x80,0x80,0x80,0x88,0x70,0x00,0x00, // C
0x00,0x00,0xF0,0x48,0x48,0x48,0x48,0x48,0x48,0xF0,0x00,0x00, // D
0x00,0x00,0xF8,0x48,0x50,0x70,0x50,0x40,0x48,0xF8,0x00,0x00, // E
0x00,0x00,0xF8,0x48,0x50,0x70,0x50,0x40,0x40,0xE0,0x00,0x00, // F
0x00,0x00,0x38,0x48,0x80,0x80,0x9C,0x88,0x48,0x30,0x00,0x00, // G
0x00,0x00,0xCC,0x48,0x48,0x78,0x48,0x48,0x48,0xCC,0x00,0x00, // H
0x00,0x00,0xF8,0x20,0x20,0x20,0x20,0x20,0x20,0xF8,0x00,0x00, // I
0x00,0x00,0x7C,0x10,0x10,0x10,0x10,0x10,0x10,0x90,0xE0,0x00, // J
0x00,0x00,0xEC,0x48,0x50,0x60,0x50,0x50,0x48,0xEC,0x00,0x00, // K
0x00,0x00,0xE0,0x40,0x40,0x40,0x40,0x40,0x44,0xFC,0x00,0x00, // L
0x00,0x00,0xD8,0xD8,0xD8,0xD8,0xA8,0xA8,0xA8,0xA8,0x00,0x00, // M
0x00,0x00,0xDC,0x48,0x68,0x68,0x58,0x58,0x48,0xE8,0x00,0x00, // N
0x00,0x00,0x70,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00, // O
0x00,0x00,0xF0,0x48,0x48,0x70,0x40,0x40,0x40,0xE0,0x00,0x00, // P
0x00,0x00,0x70,0x88,0x88,0x88,0x88,0xE8,0x98,0x70,0x18,0x00, // Q
0x00,0x00,0xF0,0x48,0x48,0x70,0x50,0x48,0x48,0xEC,0x00,0x00, // R
0x00,0x00,0x78,0x88,0x80,0x60,0x10,0x08,0x88,0xF0,0x00,0x00, // S
0x00,0x00,0xF8,0xA8,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // T
0x00,0x00,0xCC,0x48,0x48,0x48,0x48,0x48,0x48,0x30,0x00,0x00, // U
0x00,0x00,0xCC,0x48,0x48,0x50,0x50,0x30,0x20,0x20,0x00,0x00, // V
0x00,0x00,0xA8,0xA8,0xA8,0x70,0x50,0x50,0x50,0x50,0x00,0x00, // W
0x00,0x00,0xD8,0x50,0x50,0x20,0x20,0x50,0x50,0xD8,0x00,0x00, // X
0x00,0x00,0xD8,0x50,0x50,0x20,0x20,0x20,0x20,0x70,0x00,0x00, // Y
0x00,0x00,0xF8,0x90,0x10,0x20,0x20,0x40,0x48,0xF8,0x00,0x00, // Z
0x00,0x38,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x38,0x00, // [
0x00,0x40,0x40,0x40,0x20,0x20,0x10,0x10,0x10,0x08,0x00,0x00, // <Backslash>
0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x70,0x00, // ]
0x00,0x20,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ^
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC, // _
0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // '
0x00,0x00,0x00,0x00,0x00,0x30,0x48,0x38,0x48,0x3C,0x00,0x00, // a
0x00,0x00,0xC0,0x40,0x40,0x70,0x48,0x48,0x48,0x70,0x00,0x00, // b
0x00,0x00,0x00,0x00,0x00,0x38,0x48,0x40,0x40,0x38,0x00,0x00, // c
0x00,0x00,0x18,0x08,0x08,0x38,0x48,0x48,0x48,0x3C,0x00,0x00, // d
0x00,0x00,0x00,0x00,0x00,0x30,0x48,0x78,0x40,0x38,0x00,0x00, // e
0x00,0x00,0x1C,0x20,0x20,0x78,0x20,0x20,0x20,0x78,0x00,0x00, // f
0x00,0x00,0x00,0x00,0x00,0x3C,0x48,0x30,0x40,0x78,0x44,0x38, // g
0x00,0x00,0xC0,0x40,0x40,0x70,0x48,0x48,0x48,0xEC,0x00,0x00, // h
0x00,0x00,0x20,0x00,0x00,0x60,0x20,0x20,0x20,0x70,0x00,0x00, // i
0x00,0x00,0x10,0x00,0x00,0x30,0x10,0x10,0x10,0x10,0x10,0xE0, // j
0x00,0x00,0xC0,0x40,0x40,0x5C,0x50,0x70,0x48,0xEC,0x00,0x00, // k
0x00,0x00,0xE0,0x20,0x20,0x20,0x20,0x20,0x20,0xF8,0x00,0x00, // l
0x00,0x00,0x00,0x00,0x00,0xF0,0xA8,0xA8,0xA8,0xA8,0x00,0x00, // m
0x00,0x00,0x00,0x00,0x00,0xF0,0x48,0x48,0x48,0xEC,0x00,0x00, // n
0x00,0x00,0x00,0x00,0x00,0x30,0x48,0x48,0x48,0x30,0x00,0x00, // o
0x00,0x00,0x00,0x00,0x00,0xF0,0x48,0x48,0x48,0x70,0x40,0xE0, // p
0x00,0x00,0x00,0x00,0x00,0x38,0x48,0x48,0x48,0x38,0x08,0x1C, // q
0x00,0x00,0x00,0x00,0x00,0xD8,0x60,0x40,0x40,0xE0,0x00,0x00, // r
0x00,0x00,0x00,0x00,0x00,0x78,0x40,0x30,0x08,0x78,0x00,0x00, // s
0x00,0x00,0x00,0x20,0x20,0x70,0x20,0x20,0x20,0x18,0x00,0x00, // t
0x00,0x00,0x00,0x00,0x00,0xD8,0x48,0x48,0x48,0x3C,0x00,0x00, // u
0x00,0x00,0x00,0x00,0x00,0xEC,0x48,0x50,0x30,0x20,0x00,0x00, // v
0x00,0x00,0x00,0x00,0x00,0xA8,0xA8,0x70,0x50,0x50,0x00,0x00, // w
0x00,0x00,0x00,0x00,0x00,0xD8,0x50,0x20,0x50,0xD8,0x00,0x00, // x
0x00,0x00,0x00,0x00,0x00,0xEC,0x48,0x50,0x30,0x20,0x20,0xC0, // y
0x00,0x00,0x00,0x00,0x00,0x78,0x10,0x20,0x20,0x78,0x00,0x00, // z
0x00,0x18,0x10,0x10,0x10,0x20,0x10,0x10,0x10,0x10,0x18,0x00, // {
0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10, // |
0x00,0x60,0x20,0x20,0x20,0x10,0x20,0x20,0x20,0x20,0x60,0x00, // }
0x40,0xA4,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // ~
};  

// franklingothic_normal.c
// Font type    : Full (95 characters)
// Font size    : 16x16 pixels
// Memory usage : 3044 bytes
// Submitted by : MBWK

static const uint8_t franklingothic_normal[][32]= {

    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // <space>
    {0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00},  // !
    {0x00,0x00,0x00,0x00,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x03,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // "
    {0x00,0x00,0x00,0x00,0x06,0x60,0x06,0x60,0x06,0x60,0x1F,0xF0,0x1F,0xF0,0x0C,0xC0,0x0C,0xC0,0x3F,0xE0,0x3F,0xE0,0x19,0x80,0x19,0x80,0x19,0x80,0x00,0x00,0x00,0x00},  // #
    {0x00,0x00,0x00,0x00,0x01,0x00,0x07,0xC0,0x0D,0x60,0x0D,0x00,0x0D,0x00,0x0F,0x00,0x07,0xC0,0x01,0xE0,0x01,0x60,0x19,0x60,0x0D,0x60,0x07,0xC0,0x01,0x00,0x00,0x00},  // $
    {0x00,0x00,0x00,0x00,0x3C,0x18,0x66,0x30,0x66,0x60,0x66,0x60,0x66,0xC0,0x3D,0x80,0x01,0xBC,0x03,0x66,0x06,0x66,0x06,0x66,0x0C,0x66,0x18,0x3C,0x00,0x00,0x00,0x00},  // %
    {0x00,0x00,0x00,0x00,0x07,0x80,0x0F,0xC0,0x0C,0xC0,0x0C,0xC0,0x07,0x80,0x07,0x98,0x0D,0x98,0x18,0xD8,0x18,0xF0,0x1C,0x70,0x0F,0xF8,0x07,0x98,0x00,0x00,0x00,0x00},  // &
    {0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // '
    {0x00,0x00,0x00,0x00,0x00,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x01,0x80,0x01,0x80,0x00,0xC0,0x00,0x00,0x00,0x00,0x00,0x00},  // (
    {0x00,0x00,0x00,0x00,0x0C,0x00,0x06,0x00,0x06,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x06,0x00,0x06,0x00,0x0C,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // )
    {0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x1C,0xCE,0x1F,0xFE,0x03,0xF0,0x01,0xE0,0x03,0x30,0x07,0x38,0x02,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // *
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x07,0xF8,0x07,0xF8,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x00,0x00,0x00},  // +
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00},  // ,
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // -
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00},  // .
    {0x00,0x00,0x00,0x10,0x00,0x20,0x00,0x20,0x00,0x40,0x00,0x40,0x00,0x80,0x00,0x80,0x01,0x00,0x01,0x00,0x02,0x00,0x02,0x00,0x04,0x00,0x04,0x00,0x08,0x00,0x08,0x00},  // /
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x06,0x60,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x06,0x60,0x07,0xE0,0x03,0xC0,0x00,0x00,0x00,0x00},  // 0
    {0x00,0x00,0x00,0x00,0x01,0x80,0x03,0x80,0x07,0x80,0x0D,0x80,0x09,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x0F,0xF0,0x0F,0xF0,0x00,0x00,0x00,0x00},  // 1
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x0E,0x70,0x0C,0x30,0x00,0x30,0x00,0x70,0x00,0xE0,0x01,0xC0,0x03,0x80,0x07,0x00,0x0F,0xF0,0x0F,0xF0,0x00,0x00,0x00,0x00},  // 2
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x0E,0x30,0x0C,0x30,0x00,0x30,0x01,0xE0,0x01,0xE0,0x00,0x30,0x0C,0x30,0x0E,0x30,0x07,0xE0,0x03,0xC0,0x00,0x00,0x00,0x00},  // 3
    {0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0xE0,0x01,0xE0,0x03,0x60,0x03,0x60,0x06,0x60,0x0C,0x60,0x0F,0xF8,0x0F,0xF8,0x00,0x60,0x00,0x60,0x00,0x60,0x00,0x00,0x00,0x00},  // 4
    {0x00,0x00,0x00,0x00,0x07,0xF0,0x07,0xF0,0x06,0x00,0x06,0x00,0x06,0xE0,0x07,0xF0,0x07,0x38,0x00,0x18,0x00,0x18,0x06,0x38,0x07,0xF0,0x01,0xE0,0x00,0x00,0x00,0x00},  // 5
    {0x00,0x00,0x00,0x00,0x03,0xE0,0x07,0xF0,0x06,0x30,0x0C,0x00,0x0D,0xC0,0x0F,0xE0,0x0E,0x70,0x0C,0x30,0x0C,0x30,0x06,0x70,0x07,0xE0,0x03,0xC0,0x00,0x00,0x00,0x00},  // 6
    {0x00,0x00,0x00,0x00,0x07,0xF8,0x07,0xF8,0x00,0x30,0x00,0x30,0x00,0x60,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00},  // 7
    {0x00,0x00,0x00,0x00,0x01,0xE0,0x03,0xF0,0x06,0x18,0x06,0x18,0x06,0x18,0x03,0xF0,0x03,0xF0,0x06,0x18,0x06,0x18,0x06,0x18,0x03,0xF0,0x01,0xE0,0x00,0x00,0x00,0x00},  // 8
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x0E,0x60,0x0C,0x30,0x0C,0x30,0x0E,0x70,0x07,0xF0,0x03,0xB0,0x00,0x30,0x0C,0x60,0x07,0xE0,0x03,0x80,0x00,0x00,0x00,0x00},  // 9
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // :
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x80,0x01,0x00,0x00,0x00,0x00,0x00},  // ;
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x70,0x01,0xE0,0x07,0x80,0x0E,0x00,0x07,0x80,0x01,0xE0,0x00,0x70,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00},  // <
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xF0,0x0F,0xF0,0x00,0x00,0x0F,0xF0,0x0F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // =
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x07,0x00,0x03,0xC0,0x00,0xF0,0x00,0x38,0x00,0xF0,0x03,0xC0,0x07,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // >
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x0C,0x70,0x0C,0x30,0x00,0x30,0x00,0x60,0x00,0xC0,0x01,0x80,0x01,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00},  // ?
    {0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xE0,0x04,0x30,0x08,0x18,0x13,0xC8,0x14,0x48,0x14,0x48,0x14,0xD0,0x13,0x20,0x08,0x00,0x04,0x10,0x03,0xE0,0x00,0x00,0x00,0x00},  // @
    {0x00,0x00,0x00,0x00,0x03,0x80,0x03,0x80,0x07,0xC0,0x06,0xC0,0x06,0xC0,0x0E,0xE0,0x0C,0x60,0x0F,0xE0,0x1C,0x70,0x1C,0x70,0x18,0x30,0x38,0x38,0x00,0x00,0x00,0x00},  // A
    {0x00,0x00,0x00,0x00,0x0F,0xC0,0x0F,0xE0,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0F,0xE0,0x0F,0xE0,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0F,0xE0,0x0F,0xC0,0x00,0x00,0x00,0x00},  // B
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x0F,0xE0,0x0C,0x30,0x1C,0x30,0x18,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0x1C,0x30,0x0C,0x30,0x0F,0xE0,0x03,0xC0,0x00,0x00,0x00,0x00},  // C
    {0x00,0x00,0x00,0x00,0x0F,0xC0,0x0F,0xE0,0x0C,0x70,0x0C,0x38,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0C,0x38,0x0C,0x70,0x0F,0xE0,0x0F,0xC0,0x00,0x00,0x00,0x00},  // D
    {0x00,0x00,0x00,0x00,0x0F,0xE0,0x0F,0xE0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0xC0,0x0F,0xC0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0xE0,0x0F,0xE0,0x00,0x00,0x00,0x00},  // E
    {0x00,0x00,0x00,0x00,0x0F,0xE0,0x0F,0xE0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0F,0xC0,0x0F,0xC0,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x00,0x00},  // F
    {0x00,0x00,0x00,0x00,0x07,0x80,0x1F,0xC0,0x18,0xE0,0x30,0x60,0x30,0x00,0x30,0x00,0x31,0xE0,0x31,0xE0,0x30,0x60,0x18,0xE0,0x1F,0xE0,0x07,0x20,0x00,0x00,0x00,0x00},  // G
    {0x00,0x00,0x00,0x00,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0F,0xF0,0x0F,0xF0,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x0C,0x30,0x00,0x00,0x00,0x00},  // H
    {0x00,0x00,0x00,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00},  // I
    {0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x07,0x80,0x07,0x00,0x00,0x00,0x00,0x00},  // J
    {0x00,0x00,0x00,0x00,0x0C,0x30,0x0C,0x60,0x0C,0xC0,0x0C,0xC0,0x0D,0x80,0x0D,0x80,0x0F,0xC0,0x0E,0xC0,0x0C,0x60,0x0C,0x60,0x0C,0x30,0x0C,0x30,0x00,0x00,0x00,0x00},  // K
    {0x00,0x00,0x00,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x07,0xE0,0x07,0xE0,0x00,0x00,0x00,0x00},  // L
    {0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x3C,0x78,0x3C,0x78,0x34,0x58,0x36,0xD8,0x36,0xD8,0x32,0x98,0x33,0x98,0x33,0x98,0x31,0x18,0x31,0x18,0x00,0x00,0x00,0x00},  // M
    {0x00,0x00,0x00,0x00,0x0C,0x30,0x0E,0x30,0x0E,0x30,0x0F,0x30,0x0F,0x30,0x0D,0xB0,0x0D,0xB0,0x0C,0xF0,0x0C,0xF0,0x0C,0x70,0x0C,0x70,0x0C,0x30,0x00,0x00,0x00,0x00},  // N
    {0x00,0x00,0x00,0x00,0x01,0xE0,0x03,0xF0,0x06,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x06,0x18,0x03,0xF0,0x01,0xE0,0x00,0x00,0x00,0x00},  // O
    {0x00,0x00,0x00,0x00,0x07,0xE0,0x07,0xF0,0x06,0x18,0x06,0x18,0x06,0x18,0x07,0xF0,0x07,0xE0,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00},  // P
    {0x00,0x00,0x00,0x00,0x01,0xE0,0x07,0xF8,0x06,0x18,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0x06,0x18,0x07,0xF0,0x01,0xE0,0x00,0x3C,0x00,0x1C},  // Q
    {0x00,0x00,0x00,0x00,0x0F,0xE0,0x0F,0xF0,0x0C,0x18,0x0C,0x18,0x0C,0x18,0x0F,0xF0,0x0F,0xE0,0x0C,0x60,0x0C,0x60,0x0C,0x30,0x0C,0x30,0x0C,0x18,0x00,0x00,0x00,0x00},  // R
    {0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x0E,0x30,0x0C,0x00,0x0F,0x00,0x07,0xC0,0x01,0xE0,0x00,0x70,0x18,0x30,0x1C,0x70,0x0F,0xE0,0x07,0xC0,0x00,0x00,0x00,0x00},  // S
    {0x00,0x00,0x00,0x00,0x0F,0xF0,0x0F,0xF0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00},  // T
    {0x00,0x00,0x00,0x00,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x07,0xC0,0x03,0x80,0x00,0x00,0x00,0x00},  // U
    {0x00,0x00,0x00,0x00,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x80,0x00,0x00,0x00,0x00},  // V
    {0x00,0x00,0x00,0x00,0x31,0xC6,0x31,0xC6,0x31,0xC6,0x31,0xC6,0x1B,0x6C,0x1B,0x6C,0x1B,0x6C,0x1B,0x6C,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x0E,0x38,0x00,0x00,0x00,0x00},  // W
    {0x00,0x00,0x00,0x00,0x18,0x30,0x0C,0x60,0x0C,0x60,0x06,0xC0,0x03,0x80,0x03,0x80,0x03,0x80,0x06,0xC0,0x06,0xC0,0x0C,0x60,0x0C,0x60,0x18,0x30,0x00,0x00,0x00,0x00},  // X
    {0x00,0x00,0x00,0x00,0x0C,0x30,0x0C,0x30,0x06,0x60,0x06,0x60,0x03,0xC0,0x03,0xC0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00},  // Y
    {0x00,0x00,0x00,0x00,0x0F,0xF0,0x0F,0xF0,0x00,0x60,0x00,0x60,0x00,0xC0,0x01,0x80,0x01,0x80,0x03,0x00,0x06,0x00,0x06,0x00,0x0F,0xF0,0x0F,0xF0,0x00,0x00,0x00,0x00},  // Z
    {0x00,0x00,0x03,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x80,0x00,0x00},  // [
    {0x00,0x00,0x04,0x00,0x04,0x00,0x02,0x00,0x02,0x00,0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x40,0x00,0x40,0x00,0x20,0x00,0x20,0x00,0x10,0x00,0x10,0x00,0x08},  // <backslash>
    {0x00,0x00,0x03,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x03,0x80,0x00,0x00},  // ]
    {0x00,0x00,0x01,0xC0,0x01,0xC0,0x03,0x60,0x03,0x60,0x06,0x30,0x0C,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // ^
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00},  // _
    {0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x48,0x00,0x48,0x00,0x48,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // `
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xC0,0x0F,0xE0,0x0C,0x60,0x01,0xE0,0x07,0xE0,0x0C,0x60,0x0C,0x60,0x0F,0xE0,0x07,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // a
    {0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0D,0x80,0x0F,0xC0,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0F,0xC0,0x0B,0x80,0x00,0x00,0x00,0x00,0x00,0x00},  // b
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xE0,0x03,0xF0,0x07,0x30,0x06,0x00,0x06,0x00,0x06,0x00,0x07,0x30,0x03,0xF0,0x01,0xE0,0x00,0x00,0x00,0x00,0x00,0x00},  // c
    {0x00,0x00,0x00,0x60,0x00,0x60,0x00,0x60,0x03,0x60,0x07,0xE0,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x07,0xE0,0x03,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // d
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x07,0xC0,0x0C,0x60,0x0F,0xE0,0x0F,0xE0,0x0C,0x00,0x0C,0x60,0x07,0xC0,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00},  // e
    {0x00,0x00,0x03,0x80,0x07,0x80,0x06,0x00,0x0F,0x80,0x0F,0x80,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // f
    {0x00,0x00,0x00,0x00,0x00,0xE0,0x0F,0x80,0x1F,0xC0,0x18,0xC0,0x18,0xC0,0x1F,0xC0,0x0F,0x80,0x18,0x00,0x1F,0xC0,0x1F,0xE0,0x30,0x60,0x3F,0xC0,0x1F,0x80,0x00,0x00},  // g
    {0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0D,0xC0,0x0F,0xE0,0x0E,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // h
    {0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00},  // i
    {0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x07,0x00},  // j
    {0x00,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x60,0x0C,0xC0,0x0C,0xC0,0x0D,0x80,0x0F,0x80,0x0F,0x80,0x0C,0xC0,0x0C,0xC0,0x0C,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // k
    {0x00,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0x00,0x00,0x00,0x00,0x00},  // l
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x38,0x3F,0xFC,0x39,0xCC,0x31,0x8C,0x31,0x8C,0x31,0x8C,0x31,0x8C,0x31,0x8C,0x31,0x8C,0x00,0x00,0x00,0x00,0x00,0x00},  // m
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0xC0,0x0F,0xE0,0x0E,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // n
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x80,0x07,0xC0,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x07,0xC0,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00},  // o
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x80,0x0F,0xC0,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0F,0xC0,0x0D,0x80,0x0C,0x00,0x0C,0x00,0x0C,0x00},  // p
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xA0,0x07,0xE0,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x07,0xE0,0x03,0x60,0x00,0x60,0x00,0x60,0x00,0x60},  // q
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x60,0x03,0xE0,0x03,0x80,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // r
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x07,0xE0,0x06,0x60,0x07,0x00,0x03,0xC0,0x00,0xE0,0x06,0x60,0x07,0xE0,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00},  // s
    {0x00,0x00,0x00,0x00,0x01,0x80,0x01,0x80,0x03,0xE0,0x03,0xE0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0xE0,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00},  // t
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0x60,0x0C,0xE0,0x0F,0xE0,0x07,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // u
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x60,0x0C,0x60,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x03,0x80,0x03,0x80,0x03,0x80,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // v
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x31,0x8C,0x31,0x8C,0x19,0x98,0x1B,0xD8,0x1B,0xD8,0x1A,0x58,0x0E,0x70,0x0E,0x70,0x0C,0x30,0x00,0x00,0x00,0x00,0x00,0x00},  // w
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x60,0x06,0xC0,0x06,0xC0,0x03,0x80,0x03,0x80,0x03,0x80,0x06,0xC0,0x06,0xC0,0x0C,0x60,0x00,0x00,0x00,0x00,0x00,0x00},  // x
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x60,0x0C,0x60,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x06,0xC0,0x03,0x80,0x03,0x80,0x03,0x80,0x03,0x00,0x07,0x00,0x06,0x00},  // y
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xE0,0x03,0xE0,0x00,0x60,0x00,0xC0,0x00,0x80,0x01,0x80,0x03,0x00,0x03,0xE0,0x03,0xE0,0x00,0x00,0x00,0x00,0x00,0x00},  // z
    {0x00,0x00,0x00,0xE0,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x02,0x00,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x01,0x80,0x00,0xE0,0x00,0x00},  // {
    {0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00},  // |
    {0x00,0x00,0x03,0x80,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0x20,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x00,0xC0,0x03,0x80,0x00,0x00},  // }
    {0x00,0x00,0x00,0x00,0x03,0x98,0x07,0xF8,0x06,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // ~
};

