#include "mbed.h"
#include "LEDMatrix.h"
#include "drawings.h"
#include "anims.h"

PinName ub1=p8;
PinName ug1=p7;
PinName ur1=p6;
PinName lb2=p11;
PinName lg2=p10;
PinName lr2=p9;
PinName clk=p16;
PinName lat=p17;
PinName oe=p18;
PinName _a=p12;
PinName _b=p19;
PinName _c=p20;
PinName _d=p15;

LEDMatrix matrix(_a, _b, _c, _d,
                 oe,
                 ur1, lr2, ub1, lb2, ug1, lg2,
                 lat, clk);

Ticker scanner;

void detectionButs(void);
void gestiondespoints(void);
void automate_general(void);

int score_j1=0;
int score_j2=0;

bool resetecran=0;

const unsigned char butmax=10;
bool detection_butR=0;
bool detection_butB=0;

DigitalIn cap_butR(p21);
DigitalIn cap_butB(p22);
DigitalIn action(p25);


// Display Buffer
uint8_t displaybuf[2][WIDTH *HEIGHT] = {
    0x00
};

void scan()
{
    matrix.scan();
}

int main()
{
    
    matrix.begin((uint8_t *)displaybuf, WIDTH, HEIGHT);
    scanner.attach(scan, 0.0005);
    
    matrix.drawShiftAnim(&BabyAnim.arts[0]);
    
    matrix.clear();
    
    while(1)
    {
        detectionButs();   
        automate_general();
   
    }
}


void detectionButs(void) {
    
    typedef enum {RAS, BUTr, ATTENTEr, BUTb, ATTENTEb} type_etat;
    static type_etat etat = RAS;
    
    switch(etat) {
        
        case RAS :
            if(cap_butR == 1){
                etat = BUTr;
            }
            else if (cap_butB == 1)
                etat = BUTb;
            break;
            
        case BUTr :
            detection_butR = 1;
            etat = ATTENTEr;
            
            break;
            
        case ATTENTEr :
            detection_butR = 0;
            if(cap_butR == 0)
                etat = RAS;
            break; 

            case BUTb :
            detection_butB = 1;
            etat = ATTENTEb;
            break;
            
        case ATTENTEb :
            detection_butB = 0;
            if(cap_butB == 0)
                etat = RAS;
            break; 
    }    
}

void automate_general()
{

    typedef enum {debut,score,butR,butB,finB,finR} type_etat;
    static type_etat etat=debut;

    static char tempCharScoreB = '0';
    static char tempCharScoreR = '0';

    switch(etat)
    {
        case debut:
            matrix.drawCharString(0,0,"SCORE",7);
            matrix.drawCharString(6,16,"0",4);       
            matrix.drawCharString(12,16,":",7);
            matrix.drawCharString(19,16,"0" ,1);
            matrix.swap();
            etat=score;
        break;
        
        case butB:
            score_j1++;
            tempCharScoreB++;
            if(resetecran==1){
                matrix.clear();
                resetecran=0;
                }

            matrix.drawCharString(0,0,"SCORE",7);
            matrix.drawChar(6,16,tempCharScoreB ,4);       
            matrix.drawCharString(12,16,":",7);
            matrix.drawChar(19,16,tempCharScoreR ,1);
            matrix.swap();
            
            etat=score;
        break;
        
        case butR:
            score_j2++;
            tempCharScoreR++;
            if(resetecran==1){
                matrix.clear();
                resetecran=0;
                }
                
            matrix.drawCharString(0,0,"SCORE",7);
            matrix.drawChar(6,16,tempCharScoreB,4);       
            matrix.drawCharString(12,16,":",7);
            matrix.drawChar(19,16,tempCharScoreR,1);
            matrix.swap();
            
            etat=score;
        break;
        
        case finB:
        matrix.clear();
        matrix.drawShiftAnim(&vicBAnim.arts[0]);
        break; 
        
        case finR:
        matrix.clear();
        matrix.drawShiftAnim(&vicRAnim.arts[0]);
        break; 
    }
    if (detection_butB==1){    
            unsigned char animSelect = rand() %3;
            
            switch(animSelect){
                case 0: matrix.drawShiftAnim(&butBAnim.arts[0]);
                break;
                case 1: matrix.drawSpiralAnim(butbleu);
                break;
                case 2: matrix.drawdoorAnim(butbleu);
                break;
            }
                
            
            resetecran = 1;
            etat=butB;
    }
    if (detection_butR==1)
        {   
            unsigned char animSelect = rand() %3;
            
            switch(animSelect){
                case 0: matrix.drawShiftAnim(&butRAnim.arts[0]);
                break;
                case 1: matrix.drawSpiralAnim(butred);
                break;
                case 2: matrix.drawdoorAnim(butred);
                break;
            }
            resetecran = 1;
            etat=butR;
        }
            
    if (score_j1==butmax)
             etat=finB; 
             
    if(score_j2==butmax)
            etat=finR;

}
