#include "fonts.h"

#include "smallFont.h"
#include "moyen.h"

bool Font::isInit = false;
vector<Font *> Font::listFonts;

Font::Font(int l, int h, int nb, uint8_t *d, char start = ' ')
{
    larg = l;
    haut = h;
    nbCarac = nb;
    data = d;
    _start = start;
}

uint8_t Font::octet(int carac, int i, int j) const
{
    carac = carac - _start;
    if (carac>=nbCarac) return 0;
    return data[carac*larg*haut+i*larg+j];
}

const Font *Font::getFont(int n)
{
    if (!isInit) initFonts();
    if ((n>=listFonts.size())||(n<0)) n = 0;
    return listFonts[n];
}

void Font::initFonts()
{
    if (isInit) return;
    listFonts.push_back(new Font(1, 12, 95, (uint8_t *)SmallFont));
    listFonts.push_back(new Font(2, 16, 95, (uint8_t *)franklingothic_normal));
    listFonts.push_back(new Font(2, 32, 95, (uint8_t *)Grotesk16x32));
    listFonts.push_back(new Font(1, 16, 10, (uint8_t *)digitals, '0'));
    isInit = true;
}

