#ifndef __LED_MATRIX_H__
#define __LED_MATRIX_H__

#include "mbed.h"
#include "fonts.h"
#include "artanim.h"

#define WIDTH   32
#define HEIGHT  32

#define Black           0      /*   0,   0,   0 */
#define Blue            4      /*   0,   0, 255 */
#define Green           2      /*   0, 255,   0 */
#define Cyan            6      /*   0, 255, 255 */
#define Red             1      /* 255,   0,   0 */
#define Magenta         5      /* 255,   0, 255 */
#define Yellow          3      /* 255, 255,   0 */
#define White           7      /* 255, 255, 255 11111 111111 11111 */

class LEDMatrix {
public:
    LEDMatrix(PinName pinA, PinName pinB, PinName pinC, PinName pinD, PinName pinOE,
              PinName pinR1, PinName pinR2, PinName pinB1, PinName pinB2, PinName pinG1, PinName pinG2,
               PinName pinSTB, PinName pinCLK);
    
    /**
     * set the display's display buffer and number, the buffer's size must be not less than 512 * number / 8 bytes
     * @param displaybuf    display buffer
     * @param number        panels' number
     */
    void begin(uint8_t *displaybuf, uint16_t width, uint16_t height);

    /**
     * draw a point
     * @param x     x
     * @param y     y
     * @param pixel 0: led off, >0: led on
     */
    void drawPoint(uint16_t x, uint16_t y, uint8_t pixel);

    /**
     * draw a rect
     * @param (x1, y1)   top-left position
     * @param (x2, y2)   bottom-right position, not included in the rect
     * @param pixel      0: rect off, >0: rect on
     */
    void drawRect(int x1, int y1, int x2, int y2, uint8_t pixel);

    int drawChar(int x, int y, char c, uint8_t pixel, int font=Font::NORMAL_8x12);
   
    void drawCharString (int x, int y, char *c, uint8_t pixel, int font=Font::NORMAL_8x12);
    
//    void drawCharBig(uint16_t x, uint16_t y, char c, uint8_t pixel);

    /**
     * draw a image
     * @param (x1, y1)   top-left position
     * @param (x2, y2)   bottom-right position, not included in the rect
     * @param pixels     contents, 1 bit to 1 led
     */
    void drawImage(int x, int y, uint8_t w, uint8_t h, uint8_t *image);
    
    void drawArt(artDisplay * art);
    void drawArtAnim(artAnim * anim);
    
    void drawShiftAnim(artDisplay * art);
    void drawSpiralAnim(uint8_t artToDraw[32][32]);
    void drawdoorAnim(uint8_t artToDraw[32][32]);

    /**
     * Set screen buffer to zero
    */
    void clear();

    /**
     * turn off 1/16 leds and turn on another 1/16 leds
    */
    void scan();

    void reverse();

    uint8_t isReversed();

    void on();

    void off();

    void swap();
    
    int synchro();
    
    void waitImages(int nb);
    
private:
    //DigitalOut a, b, c, d, r1, r2, b1, b2, g1, g2;
    DigitalOut oe, stb, clk;
    BusOut _row;
    BusOut _rgb1, _rgb2;
    uint8_t *displaybuf, *memoBuf, *drawBuf;
    uint16_t width;
    uint16_t height;
    uint8_t  mask;
    uint8_t  state;
    int bufferIndex;
    volatile int flagSwap;
    volatile int nbImages;
};

#endif

