 #include "LEDMatrix.h"
#include "mbed.h"

LEDMatrix::LEDMatrix(PinName pinA, PinName pinB, PinName pinC, PinName pinD, PinName pinOE,
                     PinName pinR1, PinName pinR2, PinName pinB1, PinName pinB2, PinName pinG1, PinName pinG2,
                     PinName pinSTB, PinName pinCLK) :
    oe(pinOE), stb(pinSTB), clk(pinCLK),
    _row(pinA, pinB, pinC, pinD), _rgb1(pinR1, pinG1, pinB1), _rgb2(pinR2, pinG2, pinB2)
{
    clk = 0;
    oe = 1;
    stb = 1;
    mask = 0xff;
    state = 0;
    bufferIndex = 0;
    flagSwap = 0;
    nbImages = 0;
}

void LEDMatrix::begin(uint8_t *displaybuf, uint16_t width, uint16_t height)
{
    this->displaybuf = displaybuf;
    memoBuf = displaybuf;
    drawBuf = memoBuf + width * height;
    this->width = width;
    this->height = height;

    state = 1;
}

void LEDMatrix::drawPoint(uint16_t x, uint16_t y, uint8_t pixel)
{
    if (x>=width) return;
    if (y>=height) return;
    drawBuf[x+ width * y] = pixel & 0x07;
}

void LEDMatrix::drawRect(int x1, int y1, int x2, int y2, uint8_t pixel)
{
    for (int x = x1; x < x2; x++) {
        for (int y = y1; y < y2; y++) {
            drawPoint((uint16_t)x, (uint16_t)y, pixel);
        }
    }
}

int LEDMatrix::drawChar(int x, int y, char c, uint8_t pixel, int font)
{
    int i, j,k, col, max = 0;
    const Font *fptr = Font::getFont(font);
    for (i=0; i<fptr->hauteur(); i++) {
        for (k=0; k<fptr->largeur(); k++) {
            col = fptr->octet(c, i, k);
            for (j=8; j>=0; j--) {
                if (col & 0x01 != 0) {
                    int dx = j+8*k;
                    if (dx > max) max = dx;
                    drawPoint((uint16_t)(x + dx), (uint16_t)(y+i), pixel);
                }
                col = col >> 1;
            }
        }
    }
    if (c==' ') {
        return 5*fptr->largeur();
    } else {
        return max + fptr->largeur();
    }
}


void LEDMatrix::drawCharString (int x, int y, char *c, uint8_t pixel, int font)
{
    int i=0;
    while(c[i] != '\0') {
        int dx = drawChar(x,y,c[i],pixel,font);
        i++;
        x += dx;
    }
}


void LEDMatrix::drawImage(int x, int y, uint8_t w, uint8_t h, uint8_t *image)
{
    for (int i = 0; i < h; i++) {
        for (int j = 0; j < w; j++) {
            drawPoint(x+j, y+i, *image);
            image++;
        }
    }
}

void LEDMatrix::drawArt(artDisplay * art)
{
    this->drawImage(art->offset_x,art->offset_y,art->width,art->height,(uint8_t *)art->art);
}

void LEDMatrix::drawArtAnim(artAnim * anim)
{
    for(int i=0; i < anim->steps; i++)
    {
        this->clear();
        this->drawArt(&anim->arts[i]);
        this->swap();
        while (!this->synchro());
        wait_ms(anim->arts[i].duration); 
    }
}

void LEDMatrix::drawShiftAnim(artDisplay * art){
    
    for(int i=0; i < 33; i++)
    {
        this->clear();
        this->drawImage(32-i, art->offset_y, art->width, art->height, (uint8_t *)art->art);
        this->swap();
        while (!this->synchro());
        wait_ms(60);
    }
    wait_ms(500);
    this->clear();
    this->swap();
    
    wait_ms(500);
    this->drawImage(32, art->offset_y, art->width, art->height, (uint8_t *)art->art);
    this->swap();
    
    wait_ms(500);
    this->clear();
    this->swap();
    
    wait_ms(500);
    this->drawImage(32, art->offset_y, art->width, art->height, (uint8_t *)art->art);
    this->swap();
    
}

void LEDMatrix::drawdoorAnim(uint8_t artToDraw[32][32]){
    this->clear();
    
    for(unsigned char j = 0; j<16; j++){
    
        for(int i=0; i < 33; i++){
            
            if(artToDraw[i][j]){
            
                this->drawPoint(j, i, artToDraw[i][j]);
                this->swap();
                while (!this->synchro());
                wait_ms(5);
                
            }
            
            if(artToDraw[i][32-j]){
            
                this->drawPoint(31-j, i, artToDraw[i][32-j]);
                this->swap();
                while (!this->synchro());
                wait_ms(5);
            }
        }
    }
    this->clear();
    this->swap();
    
    wait_ms(500);
    this->drawImage(0, 0, 32, 32, artToDraw[0]);
    this->swap();
    
    wait_ms(500);
    this->clear();
    this->swap();
    
    wait_ms(500);
    this->drawImage(0, 0, 32, 32, artToDraw[0]);
    this->swap();
}

void LEDMatrix::drawSpiralAnim(uint8_t artToDraw[32][32]){
    
    unsigned char x = 32, y = 32;
    this->clear();
    for(int i=0; i < x; i++)
    {   
    
        for(int j=0; j<y; j++){
            if(!artToDraw[i][j]) continue;
            this->drawPoint(j, i, artToDraw[i][j]);
            this->swap();
            wait_ms(5);
        }
        
        for(int j=1; j<y; j++){
            if(!artToDraw[j][x-1]) continue;
            this->drawPoint(x-1, j, artToDraw[j][x-1]);
            this->swap();
            wait_ms(5);
        }
        
        for(int j=1; j<y; j++){
            if(!artToDraw[y-1][y-j-1]) continue;
            this->drawPoint((y-j-1), y-1, artToDraw[y-1][y-j-1]);
            this->swap();
            wait_ms(5);    
        }
        
        for(int j=1; j<y; j++){
            if(!artToDraw[y-j-2][i]) continue;
            this->drawPoint(i, (y-j-2), artToDraw[y-j-2][i]);
            this->swap();
            wait_ms(5);
        }
    
            x--;
            y--;
            
    }
    this->clear();
    this->swap();
    
    wait_ms(500);
    this->drawImage(0, 0, 32, 32, artToDraw[0]);
    this->swap();
    
    wait_ms(500);
    this->clear();
    this->swap();
    
    wait_ms(500);
    this->drawImage(0, 0, 32, 32, artToDraw[0]);
    this->swap();
}


void LEDMatrix::clear()
{
    uint8_t *ptr = drawBuf;
    for (uint16_t i = 0; i < (width * height); i++) {
        *ptr = 0x00;
        ptr++;
    }
}

void LEDMatrix::reverse()
{
    mask = ~mask;
}

uint8_t LEDMatrix::isReversed()
{
    return mask;
}

void LEDMatrix::scan()
{
    if (!state) {
        return;
    }

    static uint8_t row = 0;

    int debut1 = 256 + (row) * width;
    int debut2 = 768 + (row) * width;
    for (uint8_t i = 0; i <32 ; i++) 
    {
        _rgb1 = displaybuf[debut1+i];
        _rgb2 = displaybuf[debut2+i];
        clk = 0;
        clk = 1;
    }
 /*   debut1 = 0 + (row+8) * width;
    debut2 = 512 + (row+8) * width;
    
    for (uint8_t i = 0; i <32 ; i++) {
        _rgb1 = displaybuf[debut1+i];
        _rgb2 = displaybuf[debut2+i];
        clk = 0;
        clk = 1;
    }*/
    debut1 = 0 + row * width;
    debut2 = 512 + row * width;
    for (uint8_t i = 0; i <32 ; i++) {
        _rgb1 = displaybuf[debut1+i];
        _rgb2 = displaybuf[debut2+i];
        clk = 0;
        clk = 1;
    }

    oe = 1;
    stb = 1;

    _row = row;

    oe = 0;
    stb = 0;

    row=(row + 1) & 0x07;
    if (row==0) {
        nbImages++;
        if (flagSwap == 1) {
            if (bufferIndex==0) {
                bufferIndex = 1;
                displaybuf = memoBuf + width*height;
                drawBuf = memoBuf;
            } else {
                bufferIndex = 0;
                displaybuf = memoBuf;
                drawBuf = memoBuf + width*height;
            }
            flagSwap = 0;
        }
    }
}

void LEDMatrix::on()
{
    state = 1;
}

void LEDMatrix::off()
{
    state = 0;
    oe = 1;
}

void LEDMatrix::swap()
{
    flagSwap = 1;
}

int LEDMatrix::synchro()
{
    return !flagSwap;
}

void LEDMatrix::waitImages(int nb)
{
    while (nbImages < nb) wait_us(100);
    nbImages = 0;
}

