/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */
 
#include "mbed.h"

Serial JeVois(D5,D4,115200);
Serial usb(USBTX,USBRX,115200);

char tab[12];
bool print = true;
void JeVois_ISR(void);
int main() {
              
    JeVois.attach(&JeVois_ISR,Serial::RxIrq);
    while(true) {
      if (print){
        for(int i = 0 ; i < 11 ; i++){
            usb.putc(tab[i]);
        }
        print = false;
        wait_ms(1);
      }
    }
} 
void JeVois_ISR(void)
{
    static char temp_tab[12];
    static char cpt = 0;
    temp_tab[cpt] = JeVois.getc();
    cpt++;
    if(cpt >= 11){
        cpt = 0;
        for(int i = 0 ; i <11 ; i++){
            tab[i] = temp_tab[i];
        }
        print = true;
    }
}
