#include "mbed.h"

#include "TMP102.h"

#define LF "\r\n"

Serial pc(USBTX, USBRX); // tx, rx to PC

TMP102 temperature(p9, p10, 0x90); //A0 pin is connected to ground

int main()
{
  pc.printf("TMP102 logger ready. Press 'u' to see the temperature." LF);
  
  while(1) {
    //whenever the computer sends a 'u', give it the current temperature.
    char c = pc.getc();
    if (c == 'u') {
        pc.printf("%f" LF, temperature.read());
    }
    wait(1);
  }
  return 0;
}
