#include "mbed.h"
#include "BtnEventM0.h"

BusOut lb(P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
BusOut stLED(P1_13,P1_12);
BtnEventM0 sw4(P1_16), sw3(P0_23);


class Fahrradleuchte{
    public:
        void Init()
        {
            state=1; t1.start();    
        }
        void State1Func();
        void State2Func();
        void State3Func();
    public:
        void State1Action(); // Bit0 (LED) mit 10Hz blinken 
        void State2Action(); // Bit2 (LED) mit 5Hz blinken
        void State3Action(); // Bit3 (LED) mit 2Hz blinken
    public:
        int state; // State sagt uns in welchem Zustand sich die Fahrradleuchte gerade befindet
        Timer t1;
};

// Ein Objekt Fahrradleuchte anlegen
Fahrradleuchte fl;

int main(void)
{
     sw3.Init(); sw4.Init();
     lb=0;  
     while(1)
     {
        if(fl.state==1)
        {fl.State1Func();}
        if(fl.state==2)
        {fl.State2Func();}   
        if(fl.state==3)
        {fl.State3Func();}       
     } 
}

void Fahrradleuchte::State1Func()
{
    // Einmalige Aktion die beim Eintrit in die Funktion nötig sind
    stLED=1;
    
    //
    
    while(1)
    {
         State1Action();
         if(sw4.CheckFlag() ) // Btn's abfragen und möglicherweise Zustand ändern
         {
            state=2;
            return;    
         }   
         if(sw3.CheckFlag() )
         {
            state=3; return;    
         }
    }
}

void Fahrradleuchte::State1Action()
{
    if(t1.read_ms()>100)
    {
        t1.reset();
        if(lb==0)
            lb= 1; // Mit Bit0 blinken 
        else
            lb=0;
    }    
}

void Fahrradleuchte::State2Func()
{
    
}

void Fahrradleuchte::State3Func()
{
    
}