/*! \file config.h
\brief A Documented file.
* name:   config.h    Version: 3.0 \n
* author: PE HTL BULME \n
* email:  pe@bulme.at \n
* description:
*    Wiring for ur_Bertl The Robot
*/

#include "mbed.h"
#include "hcsr04.h"
#include "const.h"

#ifndef CONFIG_H
#define CONFIG_H
/*! \def DEBUG
\brief Turns debugging infos off (0) and on (3) which are send to serial pc.uart */
#define DEBUG 0
//#define FRONTBUTTON       /**< Error shutoff if Bertl moves against a wall*/
#define HCSR                /**< if ultrsonic is installed*/
#define MOTORENC P1_12        /**< P1_12: left encoder P1_13: rigth encoder (motor) */

BusOut NibbleLEDs(P1_8, P1_9, P1_10, P1_11);   /**< 4 yellow LEDs as a bus defined; use it i.e.: karel.NibbleLeds(karel.GetLineValues()); to show line sensor values */
DigitalOut LED_D10(P1_8);    /**<  wiring first LED_D10 */
DigitalOut LED_D11(P1_9);    /**<  wiring second LED_D11 */
DigitalOut LED_D12(P1_10);   /**<  wiring thired LED_D12 */
DigitalOut LED_D13(P1_11);   /**<  wiring fourth LED_D13 */

DigitalOut LED_blue(P1_28);  /**<  all blue LEDs are on Port 1_28   */ 

DigitalOut RGB_blue(P1_24);  /**< RGB blue component of the color uP -> Port 1_24 */
DigitalOut RGB_red(P1_23);   /**< RGB red component of the color uP -> Port 1_23 */    
DigitalOut RGB_green(P1_25); /**< RGB green component of the color uP -> Port 1_25 */ 

//------------------ CHANGE ONLY IF NESSESARY -------------------------------------

DigitalOut MotorL_EN(p34);    // wiring motor left
DigitalOut MotorL_FORWARD(P1_1);
DigitalOut MotorL_REVERSE(P1_0);

DigitalOut MotorR_EN(p36);     // wiring motor right
DigitalOut MotorR_FORWARD(P1_3);
DigitalOut MotorR_REVERSE(P1_4);

I2C i2c(p28,p27);   
BusIn linesensor(p18, p16, p19, p17);  
DigitalIn SensorL(P1_12);     /**<  motor sensor left on Port P1_12 */
DigitalIn SensorR(P1_13);     /**<  motor sensor right on Port P1_13 */
HCSR04  usensor(p21,p22);     // HC-SR04 ultrasonic sensor
PwmOut mg1(P1_15);            // PWM out motor left
PwmOut mg2(P0_21);            // PWM out motor right

Serial pc(USBTX, USBRX);      // tx, rx  

#if defined(DEBUG) && DEBUG > 0
 #define DEBUG_PRINT(fmt, args...) fprintf(stderr, "DEBUG: %s:%d:%s(): " fmt, \
    __FILE__, __LINE__, __func__, ##args)
#else
 #define DEBUG_PRINT(fmt, args...) /* Don't do anything in release builds */
#endif

#endif