/***********************************
name:   BERTL_2014_LAMPENTEST 
modyfied by ENE@bulme.at
description:
  Alle LED sind INVERS dh 0 = EIN;  1 = AUS;
***************************************/
#include "mbed.h"               // Softwarestand: 19.1.2014
/*** Portkonfiguration ***/
Serial pc(USBTX, USBRX);        // tx, rx
I2C i2c(p28,p27);

/*** Funktionsdefinitionen ***/
const int addr = 0x40;          // I2C-Adresse des PCA9555
char cmd[3];                    // Datenarray für I2C

/*** Funktionen ***/
int main()
{
        /*** I2C Konfigurationen ***/
        i2c.frequency(40000);    // I2C Frequenz 40kHz
        cmd[0] = 0x06;           // Comman6 6 Portkonfiguration Port 0
        cmd[1] = 0x00;           // 00-> Port 0 = OUTPUT (all Pins 00)
        i2c.write(addr, cmd, 2); // Sende Adresse 0x40; cmd, s  -> 0x06 0x00
                                 // Defines Port0 as Output
        cmd[0] = 0x02;           // OUTPUT Port 0 
        
/*** Hauptprogramm - Endlosschleife ***/
    while(1) 
    {                                               
                                 //                   0x00      
        cmd[1] = 0x00;           // Alle LED EIN      0000 0000
        i2c.write(addr, cmd, 2); 
        wait(2); 
                                 //                 0xF    F 
        cmd[1] = 0x00;           // Alle LED AUS      1111 1111
        i2c.write(addr, cmd, 2); 
        wait(0.5); 
                                 //                   F    E
        cmd[1] = 0xFE;           // D1 vorn links ws  1111 1110
        i2c.write(addr, cmd, 2); 
        wait(0.5);
                                 //                    F    D          
        cmd[1] = 0xFD;           // D2 vorn links ge   1111 1101
        i2c.write(addr, cmd, 2); 
        wait(0.5);
                                 //                    F    B   
        cmd[1] = 0xFB;           // D4 vorn rechts ws  1111 1011
        i2c.write(addr, cmd, 2); 
        wait(0.5);
        
        cmd[1] = 0xF7;           // sieh ab hier in den Schaltplan 
        i2c.write(addr, cmd, 2); 
        wait(0.5);
        
        cmd[1] = 0xEF;           // 
        i2c.write(addr, cmd, 2); 
        wait(0.5);
        
        cmd[1] = 0xDF;           // 
        i2c.write(addr, cmd, 2); 
        wait(0.5);
        
        cmd[1] = 0xBF;           
        i2c.write(addr, cmd, 2); 
        wait(0.5);
        
        cmd[1] = 0x7F;           
        i2c.write(addr, cmd, 2); 
        wait(0.5);
                                 //                   F    F   
        cmd[1] = 0xFF;           // Alle LED AUS      1111 1111
        i2c.write(addr, cmd, 2); 
        wait(1);                                                                                   
    }
}
