#include "mbed.h"
#include "C12832.h"

#define NORD 0
#define OST 1
#define WEST 2
#define SUED 3
#define FIRE 4

C12832 lcd1(p5, p7, p6, p8, p11);
Ticker lcdram;

InterruptIn nord(p15);
InterruptIn ost(p16);
InterruptIn west(p13);
InterruptIn sued(p12);
InterruptIn fire(p14);

int display = NORD;
char buffer[6];

void show()
{
          lcd1.cls();
              switch(display)
                {
                    case NORD:                      
                        sprintf(buffer, "NORD 0");                      
                        break;
                    case OST:                   
                        sprintf(buffer, "OST  1");
                        break;
                    case WEST:
                        sprintf(buffer, "WEST 2");
                        break;
                    case SUED:
                        sprintf(buffer, "SUED 3");
                        break;
                    default:
                          sprintf(buffer,  "FIRE 4");
                          break;
            }   
        lcd1.text(8,5,buffer,6,3);
        lcd1.rectangle(0,127,0,31); 
}


void isrnord()
{
      display = NORD;
      show();
}

void isrost()
{
      display = OST;
      show();
}

void isrwest()
{
      display = WEST;
      show();
}

void isrsued()
{
      display = SUED;
      show();
}

void isrfire()
{
      display = FIRE;
      show();
}

void update()
{
   lcd1.copy_to_lcd();
}



int main()
{    
    lcdram.attach(&update,0.1); 

    nord.rise(&isrnord);
    ost.rise(&isrost);
    west.rise(&isrwest);
    sued.rise(&isrsued);
    fire.rise(&isrfire);
    
    lcd1.cls();   
    
    
    while(1)
    {
        
    }
}
