/* mbed library for the mbed Lab Board  128*32 pixel LCD
 * use C12832 controller
 * Copyright (c) 2012 Peter Drescher - DC2PD
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Library überarbeitet: 15.1.2014 Copyright (c) Dr.C.Eichtinger
 * File GraphicDisplay und TextDisplay, sowie small_7 font gestrichen
 * C12832.h und C12832.cpp überarbeitet und mit Ziffernfont ergänzt
 * Erweiterung: Zeichengröße 1..4
 */
#ifndef C12832_H
#define C12832_H

class C12832 {
public:
    C12832(PinName mosi, PinName sck, PinName reset, PinName a0, PinName ncs);
    void pixel(int x, int y,int colour);
    void copy_to_lcd(void);    
    void cls();
    void set_contrast(unsigned char volume);
    
    SPI _spi;
    DigitalOut _reset;
    DigitalOut _A0;
    DigitalOut _CS;

    void invert(unsigned int o);    
    void rectangle(int x0,int x1,int y0,int y1);   
    int character(int ix, int iy, char c, int size);
    void text(int ix, int iy, char* ctext, int length, int size);
    
    
protected:
    void lcd_reset();
    void wr_dat(unsigned char value);
    void wr_cmd(unsigned char value);
    unsigned char buffer[512];
};


#endif