#include "mbed.h"
#include "SB1602E.h"
#include "debounceIn.h"
#define USE_I2C_2V8

DigitalOut myled(P0_8); // 7=rot, 8=grün, 9=blau
//DigitalIn sw_o(P0_12);
//DigitalIn sw_b(P0_13);
//DigitalIn sw_g(P0_14);

InterruptIn redButton(P0_12);
InterruptIn blueButton(P0_13);
InterruptIn greenButton(P0_14);

I2C i2c_disp(P0_5, P0_4); //  SDA, SCL auf LPC11U24
SB1602E lcd(i2c_disp);

int count_o, count_b, count_g = 0;

void btnRedPressed()
{
    wait_us(200);
    if(redButton == 0)
        count_o++;    
}

void btnBluePressed()
{
    wait_us(200);
    if(blueButton == 0)
        count_b++;    
}

void btnGreenPressed()
{
    wait_us(200);
    if(greenButton == 0)
        count_g++;    
}

int main()
{
    lcd.printf(0, "Red Blue Green\r");    //  Parameter von printf auf LCD: Zeilennummer (0 or 1), string
    
    redButton.mode(PullUp);
    blueButton.mode(PullUp);
    greenButton.mode(PullUp);
    
    redButton.fall(&btnRedPressed);
    blueButton.fall(&btnBluePressed);
    greenButton.fall(&btnGreenPressed);
    
    while(1) 
    {
        lcd.printf( 1,1, "%d   %d   %d", count_o, count_b, count_g);
        myled = !myled;
    }
}