#include "mbed.h"

class debounceIn : public DigitalIn
{
public:
    /* Liest den entprellten Schattenwert des Pins */
    int read(void)
    {
        return shadow;
    }
    
    /* Stellt ein, wie oft der Pin als 1 bzw. als 0 gelesen werden muss um den Schatten-Zustand zu Schalten */
    void setSamples(int i)
    {
        samples = i;   
    }
    
    void setDebounce_us(int us)
    {
       ticker.attach_us(callback(this,&debounceIn::cb),us);
    }
    
    /* Konstruktor */
    debounceIn(PinName pin ) : DigitalIn(pin)
    {   }
protected:
    void cb()
    {
        if(DigitalIn::read())
        {
            if(counter < samples) counter++;
            if(counter == samples) shadow = 1;
        }
        else
        {
            if(counter > 0) counter--;
            if(counter == 0) shadow = 0;        
        }            
    }       
    int shadow;
    int counter;
    int samples;
    Ticker ticker;
};
    