
#include "mbed.h"
#include "Serial_HL.h"
#include "FuncGen.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);
AnalogOut dacout(p18);

// BusOut leds(LED1,LED2,LED3,LED4); Bertl14
// M0-Board
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

void CommandHandler();
void ExecSignalChain();
void output();

RectGen fg1;
SignedRampGen rg1;
TriangleGen tg1;
SinusGen sg1;

Ticker ticker;

float ampl1 = 0.5; 
float v1; // Wert nach dem Koeffizientenglied
float v2;
float v3;
float v4;

int mode = 1;

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200); // 115200
    leds = 9;
    ua0.SvMessage("FuncGenMain"); // Meldung zum PC senden    
    ticker.attach_us(&output,45);
    while(1) {
        CommandHandler();
    }
    return 1;
}

// Einen Abtastschritt der Signalverarbeitungskette durchrechnen
// 100Hz zum Testen und alles Visualisieren
// 40kHz zum Anhören
void ExecSignalChain()
{
    fg1.CalcOneStep();
    v1 = 0.5 + ampl1 * fg1.val; // Koeffizientenglied rechnen 
    
    rg1.CalcOneStep();
    v2 = 0.5 + ampl1 * rg1.val;
    
    tg1.CalcOneStep();
    v3 = 0.5 + ampl1 * tg1.val;
    
    sg1.CalcOneStep();
    v4 = 0.5 + ampl1 * sg1.val;
}
void output()
{
    ExecSignalChain();
    if(mode==1)
        dacout = v1;
    else if(mode==2)
        dacout = v2;
    else if(mode==3)
        dacout = v3;
    else
        dacout = v4;
}

void CommandHandler()
{
    uint8_t cmd;
    // Fragen ob überhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return;

    // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();

    // mit dem Command=2 die Frequenz verstellen
    if( cmd==2 ) {
        float frequ = ua0.ReadF();
        fg1.SetFrequ(frequ);
        rg1.SetFrequ(frequ);
        tg1.SetFrequ(frequ);   
        sg1.SetFrequ(frequ); 
        ua0.SvMessage("Set Frequ");
    }
    if( cmd==3 ) {
        int points = ua0.ReadI16();
        fg1.SetPointsPerPeriod(points);
        rg1.SetPointsPerPeriod(points);
        tg1.SetPointsPerPeriod(points);   
        ua0.SvMessage("Set Points");
    }   
    if( cmd ==4)
    {
        mode = ua0.ReadI16();
    }
    
}


