
#include "FuncGen.h"
#include "mbed.h"

// Konstruktor
SignedRampGen::SignedRampGen()
{
    val=0;
    SetPointsPerPeriod(10);
}

void SignedRampGen::SetPointsPerPeriod(int aPoints)
{
    _inc = 2.0/aPoints;
}

void SignedRampGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}

void SignedRampGen::CalcOneStep()
{
    val = val + _inc;
    if( val>=1.0 )
        val = -1 + (val - 1.0);
}



TriangleGen::TriangleGen()
{
    val=0;
    _state=1;
    SetPointsPerPeriod(10);
}

void TriangleGen::SetPointsPerPeriod(int aPoints)
{
    _inc = 4.0/aPoints;
}

void TriangleGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}

void TriangleGen::CalcOneStep()
{
    if( _state==1 ) {
        val = val + _inc;
        if( val>1.0 ) {
            val = val - _inc;
            _state = 2;
        }
    } else if( _state==2 ) {
        val = val - _inc;
        if( val<-1.0 ) {
            val = val + _inc;
            _state = 1;
        }
    }
}



RectGen::RectGen()
{
    val=0;
    _inc=_phase=0;
    SetPointsPerPeriod(10);
    _thres = 0.5;
}

void RectGen::SetPointsPerPeriod(int aPoints)
{
    _inc = 2.0/aPoints;
}

void RectGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}
void RectGen::SetPulsWidth(float aPercent)
{
    _thres = aPercent;
}

void RectGen::CalcOneStep()
{
    _phase += _inc;
    if( _phase>=1.0 )
        _phase = _phase - 1.0;
    if( _phase>_thres )
        val = 1.0;
    else
        val = -1.0;
}

SinusGen::SinusGen()
{
    val = 0;
    _inc = 1;
    entry = 0;
    for(int i = 0; i < 1000; i++)
    {
        sinWave[i] = sin(((3.1415*2)/1000)*i); 
    }
}       

void SinusGen::SetFrequ(float aFrequ)
{
    int freq = 22000 * aFrequ;
    _inc = 1000 * freq/22000;
}

void SinusGen::CalcOneStep()
{
    val = sinWave[(int)entry];
    entry = entry + _inc;
    if(entry > 1000)
        entry = entry - 1000;
}


