#include "mbed.h"

I2C i2ca(p28,p27);
Serial pc(USBTX,USBRX);

int main() {
    pc.baud(115200);
    i2ca.frequency(400000);
    pc.printf("Temperaturmessung \n");
    
    i2ca.start();
    i2ca.write(0x90);
    i2ca.write(0x01);
    i2ca.write(0x00);
    i2ca.stop();
    
    unsigned char msb, lsb;
    int itemp;
    float temp;
    
    while(1) {
        i2ca.start();
        i2ca.write(0x90);
        i2ca.write(0x00);
        
        i2ca.start();
        i2ca.write(0x91);
        msb = i2ca.read(1);
        lsb = i2ca.read(0);
        i2ca.stop();
        
        itemp = (msb <<8) + lsb;
        temp = (float)itemp/256.0;
        
        pc.printf("Temperatur: %8.3f Grad C \n",temp);
        
        wait(1.0);
    }
}
