// Kevin Heinrich, 3AHEL, Begonnen am: 30.11.2015
// BERTL14
// selber Entwickelt 

/*
Aufgabenstellung:
Es soll eine alternativ Funktion entwickelt werden, die die PWM-Funktion fuer die Led's D10-D13 ersetzen kann

1)
Schreiben der alternativ PWM-Funktion mit wait, wait_ms bzw. wait_us
[void pwm_delay(unsigned int duty_cycle)];
T = 250 µs, t = 1 µs, LED1 = D10

2)
Schreibe ein Testprogramm, dass die Funktion pwm_delay() verwendet um die Helligkeit der LED ‚dreieckfoermig‘ zu steuern, 
so dass die Helligkeit von 0 auf 100 % ansteigt und schließlich wieder von 100 % auf 0 % absinkt.

3)
Erweitere dein Programm so, dass alle vier direkt ansteuerbaren LEDs in der Helligkeit um ‚1/4‘-versetzt angesteuert werden. 
Also dass Led D10 den 'Dreieck-Zyklus' bei 0 %, Led D11 bei 25% , Led D12 bei 50 % usw. beginnt.
*/

#include "mbed.h"

DigitalOut ledd10(P1_8);
DigitalOut ledd11(P1_9);
DigitalOut ledd12(P1_10);
DigitalOut ledd13(P1_11);
// Begin pwm_delay
// dutycycle: 0% bis 100 % gibt an, wie hell eine LED leuchtet

// Parameter sind die Verzoegerung und die LED's (da die Verzoegerung und LED's unterschiedlich 
// bei den Funktionsaufrufen sind)
void pwm_delay(unsigned int duty_cycle, DigitalOut LED)
{
    int pwm_time_index;
    // In 2 Perioden (0,5 ms) die LED ein- und ausschalten
    // Wird hier die Dauer zu lange gewaehlt, erkennt man ein flackern
    // Wird hier die Dauer zu kurz gewaehlt, erkennt man das unterschiedliche Aufleuchten der LED's nicht mehr
    for(pwm_time_index = 0; pwm_time_index<2; pwm_time_index++) 
    {
        // Abfrage, damit der Extremwert (0) fuer das Einschalten der LED zu vernachlaessigen ist
        if(duty_cycle != 0) 
        {
            LED = 1;
            wait_us(duty_cycle); // Zeit, wo die LED eingeschalten ist
        }
        // END IF
        // Abfrage, damit der Extremwert (250) fuer das Ausschalten der LED zu vernachlaessigen ist
        if(duty_cycle != 250) 
        {
            LED = 0;
            wait_us(250-duty_cycle); // Zeit, wo die LED ausgeschalten ist
        }
        // END IF
    }
    // END for

}

// END pwm_delay

int main()
{
    // Alle Leds ausschalten
    ledd10=ledd11=ledd12=ledd13 = 0;
    //Verzoegerungen definieren
    unsigned int delay1=0; // 0%
    unsigned int delay2=63; // 25%
    unsigned int delay3=125; // 50%
    unsigned int delay4=188; // 75%

    // Vergleichsvariablen definieren
    int a; // Vergleich fuer die erste Led (D10)
    int b; // Vergleich fuer die zweite Led (D11)
    int c; // Vergleich fuer die dritte Led (D12)
    int d; // Vergleich fuer die vierte Led (D13)
    
    a=b=c=d=251; //Vordefiniert fuer die IF-Anweisungen 
    // Wenn die Variablen 251 sind, wird die LED immer heller
    // Wenn die Variablen 0 sind, wird die LED immer dunkler
    // Werden dann seperat umdefiniert, da die LED's unterschiedliche Helligkeiten haben
    
    while(1) 
    {       
        //--------------LED D10---------------------\\
        
        // Jeden einzelnen Wert von der Verzoegerung der ersten Led abfragen 
        pwm_delay(delay1, ledd10); // Funktion pwm_delay wird geoeffnet
        // Und solange die Verzoegerung kleiner ist als die Vergleichsvariable
        // Soll die Verzoegerung vergroeßert werden
        if(delay1 < a)
        {
            // Die IF-Abfrage hilft, damit das Programm weiß, ob die Verzoegerung rauf- 
            // oder runtergezaehlt wird. Dafuer wurden die Vergleichsvariablen definiert.            
            if(delay1 == (a-1))
            {
                // Wenn a = 0 ist, weiß das Programm, dass jetzt die Verzoegerung hinuntergezaehlt wird
                // Wird ausgefuehrt, wenn die Verzoegerung 250 erreicht hat
                a=0;
            }
            // END IF
            
            // Das ELSE hilft, damit die Verzoegerung nicht ueber den Wert 250 hinaufgezaehlt wird
            else 
                delay1++;
            //END ELSE
        }
        // END IF
        
        // Ist die Vergleichsvariable kleiner als die Verzoegerung, wird die Bedingung der IF-Abfrage nicht
        // erfuellt und das Programm fuehrt das ELSE aus
        // Jeden einzelnen Wert von der Verzoegerung der ersten Led abfragen 
        // Und solange die Verzoegerung groeßer ist als die Vergleichsvariable
        // Soll die Verzoegerung verkleinert werden
        else
        {          
            if(delay1 == a)
            {
                a=251;
            }
            // END IF
            
            else 
                delay1--;
            //END ELSE
        }
        //END ELSE
        
        //--------------LED D11---------------------\\
        
        // Genau den gleichen Effekt wie mit der ersten Led, nur dass sie mit 25% mehr Helligkeit startet
        // Sie unterscheiden sich nur durch die Vergleichsvariablen, um sie alle
        // einzeln zu schalten
        pwm_delay(delay2, ledd11); // Funktion pwm_delay wird geoeffnet
        if(delay2 < b)
        {          
            if(delay2 == (b-1))
            {
                b=0;
            }
            // END IF
            
            else 
                delay2++;
            //END ELSE
        }
        // END IF
        
        // Gleicher Effekt wie bei der Led D10
        // Sie unterscheiden sich nur durch die Vergleichsvariablen, um sie alle
        // einzeln zu schalten
        else
        {            
            if(delay2 == b)
            {
                b=251;
            }
            else 
                delay2--;
            //END ELSE
        }
        //END ELSE
        
        //--------------LED D12---------------------\\
        
        // Gleicher Effekt wie bei Led D10, nur dass sie mit 50% mehr Helligkeit startet
        // Sie unterscheiden sich nur durch die Vergleichsvariablen, um sie alle
        // einzeln zu schalten
        pwm_delay(delay3, ledd12); // Funktion pwm_delay wird geoeffnet
        if(delay3 < c)
        {
            if(delay3 == (c-1))
            {
                c=0;
            }
            // END IF
            
            else 
                delay3++;
            //END ELSE
        }
        // END IF
        
        // Gleicher Effekt wie bei der Led D10
        // Sie unterscheiden sich nur durch die Vergleichsvariablen, um sie alle
        // einzeln zu schalten
        else
        {            
            if(delay3 == c)
            {
                c=251;
            }
            // END IF
            
            else 
                delay3--;
            //END ELSE
        }
        //END ELSE
        
        //--------------LED D13---------------------\\
        
        // Gleicher Effekt wie bei der Led D10, nur dass sie mit 75% mehr Helligkeit startet
        // Sie unterscheiden sich nur durch die Vergleichsvariablen, um sie alle
        // einzeln zu schalten
        pwm_delay(delay4, ledd13); // Funktion pwm_delay wird geoeffnet
        if(delay4 < d)
        {   
            if(delay4 == (d-1))
            {
                d=0;
            }
            // END IF
            
            else 
                delay4++;
            //END ELSE
        }
        // END IF
        
        // Gleicher Effekt wie bei der Led D10
        // Sie unterscheiden sich nur durch die Vergleichsvariablen, um sie alle
        // einzeln zu schalten
        else
        {
            if(delay4 == d)
            {
                d=251;
            }
            // END IF
            
            else 
                delay4--;
            //END ELSE
        }
        //END ELSE       
    }
}
