#include <exception>
#include <iostream>

using std::cout;
using std::endl;

class myexceptions : public std::exception
{
  public:
    enum class Error_Type {EVEN, TOO_SMALL};
  private:
    Error_Type error_type_;
  public:
    myexceptions(Error_Type error);
    myexceptions(myexceptions const &var);
    virtual const char *what() const noexcept;
    ~myexceptions();
};

myexceptions::myexceptions(Error_Type error) : error_type_ (error)
{
}

myexceptions::~myexceptions()
{
}

const char* myexceptions::what() const noexcept
{
  switch (error_type_)
  {
    case Error_Type::EVEN:
       return "error: number is even";
    case Error_Type::TOO_SMALL:  
      return  "error: number is too small";
    default:
      return NULL;
  }
  
}