/******************************************************************************

Welcome to GDB Online.
GDB online is an online compiler and debugger tool for C, C++, Python, PHP, Ruby, 
C#, VB, Perl, Swift, Prolog, Javascript, Pascal, HTML, CSS, JS
Code, Compile, Run and Debug online from anywhere in world.

*******************************************************************************/
#include <stdio.h>
#include <ctime>
//#include <cstdio>

//--------------------- Timer -----------------------//
class Time
{
    protected:
    char s = 0;
    char m = 0;
    char h = 0;

    public:
    void SetTime(char hour, char min, char sec);
    virtual char AktualHour();
    virtual char AktualMin();
    virtual char AktualSec();
};
void Time::SetTime(char hour, char min, char sec)
{
    s = sec;
    m = min;
    h = hour;
}
char Time::AktualSec()    { return s; }
char Time::AktualMin()    { return m; }
char Time::AktualHour()   { return h; }



//--------------------- Uhr -----------------------//
class Uhr : public Time
{
    private:
    // Variabeln für Uhr
    clock_t tick;
    clock_t startTick;
    char sh, sm, ss;
    // Methoden für Uhr
    void SetTick();
    int GetTickDiff();
    void SetNewTime();
    
    unsigned long TimeInSec();

    public:
    // Konstruktoren
    Uhr(Time time);
    Uhr(char sec, char min, char hour);
    // Sonstige Variabeln
    unsigned long TimeSec();
    void SetTime(char hour, char min, char sec);
    char AktualHour();
    char AktualMin();
    char AktualSec();
};
// private:
void Uhr::SetTick() { startTick = clock(); }
int Uhr::GetTickDiff()
{
    // Differenz der Startzeit bis jetzt berrechnen
    tick = clock() - startTick;
    int sec = (int)(tick/CLOCKS_PER_SEC);
    return sec;
}
void Uhr::SetNewTime()
{
    // Holen der Zeitdifferenz und setze vom Startzeitbezug eine neue Zeit
    int sec = this->GetTickDiff();
    unsigned long timeInSec = ((sh*3600) + (sm*60) + ss) + sec;
    h = (char)(timeInSec / 3600);
    m = (char)((timeInSec - (h * 3600)) / 60);
    s = (char)(timeInSec % 60);
}
unsigned long Uhr::TimeInSec()
{
    unsigned long sec = (h * 3600) + (m * 60) + s;
    return sec;
}


// public:
Uhr::Uhr(Time time) : Time()
{
    // relative Zeitvariabeln
    s = time.AktualSec();
    m = time.AktualMin();
    h = time.AktualHour();
    
    // Festgelegte Startzeit
    sh = h;
    sm = m;
    ss = s;

    // Zeitablauf starten
    this->SetTick();
}
Uhr::Uhr(char hour, char min, char sec) : Time()
{
    // relative Zeitvariabeln
    s = sec;
    m = min;
    h = hour;
    
    // Festgelegte Startzeit
    sh = h;
    sm = m;
    ss = s;

    // Zeitablauf starten
    this->SetTick();
}

unsigned long Uhr::TimeSec()
{
    // Setzt Zeit und aktuallisiert
    this->SetNewTime();
    this->TimeInSec();
}
char Uhr::AktualSec()    { this->SetNewTime(); Time::AktualSec(); }
char Uhr::AktualMin()    { this->SetNewTime(); Time::AktualMin(); }
char Uhr::AktualHour()   { this->SetNewTime(); Time::AktualHour(); }






int main()
{
    // Uhr setzen
    Uhr uhr(20, 30, 0);
    
    //oder
    Time t;
    t.SetTime(10, 2, 30);
    uhr = t;
    
    // Ausgabe der Parameter
    printf("Zeit in Sec: %lu\n", uhr.TimeSec());
    printf("Anzahl an Stunden: %d\n", uhr.AktualHour());
    printf("Anzahl an Minuten: %d\n", uhr.AktualMin());
    printf("Anzahl an Sekunden: %d\n", uhr.AktualSec());
    
    
    
    
    
    // Uhrausgabe in Sekundentakt [Zeitmäßig leider nicht genau Sekunden]
    unsigned long x = uhr.TimeSec();
    while (1)
    {
        while(x == uhr.TimeSec()){}
        
        printf("Zeit in Sec: %lu\n", uhr.TimeSec());
        x = uhr.TimeSec();
    }

    
    return 0;
}
