/* Ihre Aufgaben!
   1. ErgC$nzen Sie die Klasse Kreis um die Methode float leseFlaeche();
   
   2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Ueberlegen Sie sich welche Parameter der Konstruktur fC<r die Klasse
      Rechteck benC6tigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
      
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.
      
      Format der Dateinamen: <Nachname>_<Übungsnummer>_<Titel>
      Bsp: Brunnhofer_2_Vererbung
      
      Hinweis: Der Quellcode der Programme sollte auch kommentiert werden!
      
*/

#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{
  // In der Basisklasse werden alle gemeinsamen Variablen
protected:          
  eckig m_hat_ecken;
  float m_umfang;
  float m_flaeche;
  float m_diagonale;
  float m_rechteckumfang;
  float m_rechteckflaeche;
  float m_quadratumfang;
  float m_quadratflaeche;
  

public:         // sowie auch alle gemeinsamen Methoden deklariert
  float leseUmfang () {return m_umfang; }
  float leseFlaeche () {return m_flaeche; }
  float leseRechteckUmfang () {return m_rechteckumfang;}
  float leseRechteckFlaeche () {return m_rechteckflaeche;}
  float leseDiagonale () {return m_diagonale;}
  float leseQuadratUmfang () {return m_quadratumfang;}
  float leseQuadratFlaeche () {return m_quadratflaeche;}

  Form (eckig hat_ecken);   
  
};

Form::Form (eckig ecken)
{               // im Konstruktor werden gem. Variablen initialisiert
  m_hat_ecken = ecken;
  m_umfang = 0;
  m_flaeche = 0;
};

class Kreis:public Form
{               // Hier wird eine von Form abgeleitete Klasse Kreis deklariert

protected:          // Zugriffschutz protected bedeutet, dass abgeleitete 
  // Klassen ebenfalls zugreifen koennen.
  float m_radius;

public:
  float leseUmfang ();
  float leseFlaeche ();

    Kreis (float radius);   // Neuer Konstruktor erfordert nur den radius 
};

Kreis::Kreis (float radius): Form (nein)
{
  // Im Konstruktor werden gleich die Membervariablen initialisiert

  // Ueber den radius werden Umfang und Fläeche berechnet. 
  m_umfang = 2 * radius * M_PI; // Die Konstante M_PI ist in math.h definiert
  m_flaeche = radius * radius * M_PI;
};

float Kreis::leseUmfang ()
{
  // hier ist keine Aenderung der Funktion noetig,
  // daher wird die Funktion der Basisklasse aufger.
  return m_umfang;
};

float Kreis::leseFlaeche ()
{
  return m_flaeche;
};


class Rechteck:public Form
{               // Hier wird eine von Form abgeleitete Klasse Rechteck deklariert

protected:          // Zugriffschutz protected bedeutet, dass abgeleitete 
  // Klassen ebenfalls zugreifen koennen.
  float m_laenge;
  float m_breit;
  float m_diagonale;

public:
  float leseRechteckFlaeche ();
  float leseRechteckUmfang ();
  float leseDiagonale ();

    Rechteck (float laenge,float breit);    // Neuer Konstruktor erfordert nur den radius 
    
};

Rechteck::Rechteck (float laenge,float breit):Form (ja)
{
  // Im Konstruktor werden gleich die Membervariablen initialisiert

  // Ueber den Seiten werden Umfang und Flaeche berechnet. 
  m_rechteckumfang = 2 * (laenge + breit);
  m_rechteckflaeche = laenge * breit;
  m_diagonale=sqrt(pow(laenge,2)+ pow(breit,2));
};

float Rechteck::leseRechteckUmfang ()
{
  // hier ist keine Aenderung der Funktion noetig,
  // daher wird die Funktion der Basisklasse aufger.
  return m_rechteckumfang;
};

float Rechteck::leseRechteckFlaeche ()
{
  return m_rechteckflaeche;
};

float Rechteck::leseDiagonale ()
{
  return m_diagonale;
};

class Quadrat : public Rechteck{
    protected:      
    float m_laenge;
    //float m_breit;
    float m_diagonale;
    
    //alle Variablen kann man von public Rechteck benutzen
    
 /*Flächeninhalt = Seitenlänge * Seitenlänge
Umfang = Seite * 4
Diagonale = Wurzel aus Seite² + Seite²*/

public:
    float leseQuadratFlaeche ();
    float leseQuadratUmfang ();
    float leseDiagonale ();
    
    Quadrat(float laenge);
};

Quadrat::Quadrat (float laenge):Rechteck (laenge,laenge) //ohne datentyp bei rechteck

{
  // Im Konstruktor werden gleich die Membervariablen initialisiert

  // Ueber den Seiten werden Umfang und Flaeche berechnet. 
  m_quadratumfang = 4 * laenge ;
  m_quadratflaeche = laenge * laenge;
  m_diagonale=sqrt(pow(laenge,2)+ pow(laenge,2));
};

float Quadrat::leseQuadratUmfang ()
{
  // hier ist keine Aenderung der Funktion noetig,
  // daher wird die Funktion der Basisklasse aufger.
  return m_quadratumfang;
};

float Quadrat::leseQuadratFlaeche ()
{
  return m_quadratflaeche;
};

float Quadrat::leseDiagonale ()
{
  return m_diagonale;
};

int main ()
{
   Kreis kr(1.0);  // Hier wird der Konstruktor aufgerufen und das 
                  // damit das Objekt meineForm der Klasse Kreis
                 // mit dem radius 1.0 erstellt. auch instanziert. 
  float um = kr.leseUmfang();    // Methode wird aufgerufen von Kreis Methode
  float fl = kr.leseFlaeche();
  
  Rechteck re(3,5);
  float um_r = re.leseRechteckUmfang();    // Methode wird aufgerufen von Rechteck Methode
  float fl_r = re.leseRechteckFlaeche();
  float di_r = re.leseDiagonale();
  
  Quadrat qu(4.0);
  float um_q = qu.leseQuadratUmfang();    // Methode wird aufgerufen von Quadrat Methode
  float fl_q = qu.leseQuadratFlaeche();
  float di_q = qu.leseDiagonale();
  
  printf ("Der Kreis Umfang betraeggt: %f.\n", um);
  printf ("Der Kreis Fläche betraeggt: %f.\n", fl);
  printf ("Der Rechteck Umfang betraeggt: %f.\n", um_r);
  printf ("Der Rechteck Fläche betraeggt: %f.\n", fl_r);
  printf ("Der Rechteck Diagonale betraeggt: %f.\n", di_r);
  printf ("Der Quadrat Umfang betraeggt: %f.\n", um_q);
  printf ("Der Quadrat Fläche betraeggt: %f.\n", fl_q);
  printf ("Der Quadrat Diagonale betraeggt: %f.\n", di_q);
  
  return 0;
}
