#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

// Basisklasse
class Form           
{                   
                    
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                   
    float leseUmfang() { return m_umfang; } 
    float leseFlaeche() { return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

// Abgeleite Klasse von Forms
class Kreis : public Form { 
    
  public:                   
    float leseUmfang() {return m_umfang;} // holt sich die Werte aus der Variable m_umfang
    float leseFlaeche() {return m_flaeche;}
    
    Kreis(float radius);    
};

// Berechnet Fläche und Umfang und speichert es in der Basisklasse
Kreis::Kreis(float radius) : Form(nein) {
    
    m_umfang = 2 * radius * M_PI;  
    m_flaeche = radius * radius * M_PI;
};

// Neue von Forms abgleitete Unterklasse
class Rechteck : public Form{
    protected:
    
        float m_kantenLaenge_a;
        float m_kantenLaenge_b;
    
    public:
        
        float leseUmfang();
        float leseFlaeche();
      
    Rechteck(float a, float b);
};

// Speichert die Paramter vom Objekt in die Member
Rechteck::Rechteck(float a, float b):Form(ja){
    m_kantenLaenge_a = a;
    m_kantenLaenge_b = b;
};

// Holt sich die Werte aus den Membern und gibt den Wert auf die Methode zurück
float Rechteck::leseFlaeche(){
    return m_kantenLaenge_a * m_kantenLaenge_b;
    
}
// Holt sich die Werte aus den Membern und gibt den Wert auf die Methode zurück
float Rechteck::leseUmfang(){
    return (m_kantenLaenge_a * 2) + (m_kantenLaenge_b * 2);
    
}

// Die abgleitete Klasse von Rechteck
class Quadrad : public Rechteck{
    
     public:
        
        float leseUmfang();
        float leseFlaeche();
        
    Quadrad(float a);
};

// Speichert die Paramter vom Objekt in die Member
Quadrad::Quadrad(float a) : Rechteck(a, a){
    m_kantenLaenge_a = a;
    
};
// Holt sich die Werte aus den Membern und gibt den Wert auf die Methode zurück
float Quadrad::leseUmfang(){
    return m_kantenLaenge_a * 4;
}
// Holt sich die Werte aus den Membern und gibt den Wert auf die Methode zurück
float Quadrad::leseFlaeche(){
    return m_kantenLaenge_a * m_kantenLaenge_a;
}

int main()
{
    // Hier werden neue Objekte erstellt
    Kreis kr(1.0);
    Rechteck re(2.0, 3.0);
    Quadrad qu(5.0);
    
    // Hier greifen die Objekte auf die Methoden zu und werden mit Printf ausgegeben
    printf("Alle Werte des Kreises: \n");
    printf("Der Umfang des Kreises beträgt: %f\n", kr.leseUmfang());
    printf("Die Fläche des Kreises beträgt: %f\n", kr.leseFlaeche());
    
    printf("Alle Werte des Rechtecks: \n");
    printf("Der Umfang des Rechtecks beträgt: %f\n", re.leseUmfang());
    printf("Die Fläche des Rechtecks beträgt: %f\n", re.leseFlaeche());
    
    printf("Alle Werte des Quadrads: \n");
    printf("Der Umfang des Quadrads beträgt: %f\n", qu.leseUmfang());
    printf("Die Fläche des Quadrads beträgt: %f\n", qu.leseFlaeche());
    
    return 0;
}