
#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
    float laenge;
    float breite;
  
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float berechneUmfang() { return m_umfang; };
    float berechneFlaeche() { return m_flaeche; };

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
                            // Klassen ebenfalls zugreifen können.
    float m_radius;
    
  public:                   
    float berechneUmfang();
    float berechneFlaeche();
    
    Kreis(float radius);    // Neuer Konstruktor erfordert nur den radius 
};

Kreis::Kreis(float radius) : Form(nein) {
    // Im Konstruktor werden gleich die Membervariablen initialisiert
    
    // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};

// 2 Aufgabe
class Rechteck : public Form {
    
    protected:
    float laenge;       // länge und breite des Rechtecks
    float breite;
    
    public:
    float berechneUmfang();     // Methode berechneUmfang für Rechteck
    float berechneFlaeche();    // Methode berechneFlaeche für Rechteck
   
    Rechteck(float laenge, float breite);
};

Rechteck::Rechteck(float laenge, float breite) : Form(ja){
    
    m_umfang = 2*laenge+2*breite;   // Berechnung des Umfanges
    m_flaeche = laenge*breite;      // Berechnung der Fläche
    
}

float Rechteck::berechneUmfang() {
                                // hier ist keine Änderung der Funktion nötig,
    Form::berechneUmfang();     // daher wird die Funktion der Basisklasse aufger.
}

float Rechteck::berechneFlaeche(){ 
    
    Form::berechneFlaeche();
}

float Kreis::berechneUmfang() {
                                // hier ist keine Änderung der Funktion nötig,
    Form::berechneUmfang();     // daher wird die Funktion der Basisklasse aufger.
}

// 1 Aufgabe
float Kreis::berechneFlaeche(){ 
    
    Form::berechneFlaeche();
}


int main()
{
   
    Kreis kr(1.0);      //Hier wird zur klasse kreis zugegriffen und der wert 1 gesetzt
    float um_k = kr.berechneUmfang();       // Hier wird der Wert vom Umfang aus klasse kreis gelesen
    
    float fl_k = kr.berechneFlaeche();      // Hier wird der Wert der Fläche aus klasse kreis gelesen
    
    Rechteck re(3,2);        //Hier wird zur klasse Rechteck zugegriffen und die werte 3 und 2 gesetzt
    
    float um_r = re.berechneUmfang();        // Hier wird der Wert des Umfangs aus klasse Rechteck gelesen
    float fl_r = re.berechneFlaeche();       // Hier wird der Wert der Fläche aus klasse Rechteck gelesen
    
    printf("Der Umfang des Rechteck beträgt: %f\n", um_r);
    printf("Der Fläche des Rechteck beträgt: %f\n", fl_r);
    printf("Der Umfang des Kreis beträgt: %f\n", um_k);
    printf("Die Fläche des Kreises beträgt: %f\n", fl_k);
    
    
    return 0;
}

/* Ihre Aufgaben!
   1. Ergänzen Sie die Klasse Kreis um die Methode float berechneFlaeche();
   
   2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
      
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.

*/