#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form
{
//diese variablen werden an die Unterklasse weitergegeben
protected:
  eckig hat_ecken;
  float umfang;
  float flaeche;

//methoden um auf die Variablen zugreifen zu kC6nnen
public:
  float leseUmfang () {return umfang;};
  float leseFlaeche () {return flaeche;};
  int leseEckig() {return hat_ecken;};

//Konstruktor
    Form (eckig ecken); //es wird ein Parameter übergeben
};

//ecken kommt aus der main-Funktion. Umfang und Fläche werden auf 0 gesetzt. 
Form::Form(eckig ecken){
    hat_ecken = ecken; 
    umfang = 0.0;
    flaeche = 0.0;
};

class Kreis : public Form{
    protected:
    float radius;
  
    public:
    float leseRadius() {return radius;};
    //Diese folgenden beiden Methoden werden hier nicht benötigt, weil sie schon in der Elternklase Form vorkommen. 
    //float leseUmfang(){return umfang;}; 
    //float leseFlaeche(){return flaeche;};
    
    Kreis(float rad);
    
};

Kreis::Kreis(float rad) : Form(nein) {
    radius = rad;
    umfang = 2 * rad * M_PI;
    flaeche = rad * rad * M_PI;
};

//Klasse Rechteck wird erstellt. Umfang und Flaeche werden von der Elternklasse übernommen. 
//Methoden zum lesen von von Umfang und Flaeche werden auch aus der Elternklasse übernommen. 
class Rechteck : public Form{
  protected:
  float seitenLaengeA;
  float seitenLaengeB;
  float diagonale;
  
  public:
  float leseSeitenLaengeA(){return seitenLaengeA;};
  float leseSeitenLaengeB(){return seitenLaengeB;};
  float leseDiagonale(){return diagonale;};
  
  //Konstruktor bekommt die Seitenlaengen a und b
  Rechteck(float a, float b);
  
};

//Dem Konstruktor werden die Werte a und b des Rechecks übergeben
// mit diesen beiden Werten werden die restlichen Werte ausgerechent und über die Methoden 
//in der main-Funktion ausgegeben
Rechteck::Rechteck(float a, float b) : Form (ja){
  seitenLaengeA = a;
  seitenLaengeB = b;
  umfang = (2 * a) + (2 * b);
  flaeche = a * b;
  diagonale = sqrt((a*a) + (b*b));
    
};


int main ()
{
    //Test, ob alles funktioniert
    /*
    Form meineForm(ja); 
    int eckig = 0;
    
    eckig = meineForm.leseEckig();
    printf ("Ecken? %d", eckig);
    */
    
    //Objekt meinKreis wird erstellt und der Radius an den Konstruktor übergeben
    Kreis meinKreis(1.0);
    //Werte im Konstruktor berechnet und über Methoden ausgegeben
    float ra = meinKreis.leseRadius();
    float um = meinKreis.leseUmfang();
    float fl = meinKreis.leseFlaeche();
    printf ("meinKreis:\nRadius: %f \nUmfang: %f \nFlaeche: %f\n\n",ra, um, fl );
    
    
    
    //Objekt meinRechteck wird erstellt und die Seiten a und b an den Konstruktor übergeben
    Rechteck meinRechteck(3,4);
    //die Werte des Rechtecks werden im Konstruktor berechnet und über die Methoden ausgegeben. 
    float a = meinRechteck.leseSeitenLaengeA();
    float b = meinRechteck.leseSeitenLaengeB();
    float um_recht = meinRechteck.leseUmfang();
    float fl_recht = meinRechteck.leseFlaeche();
    float dia_recht = meinRechteck.leseDiagonale();
    printf ("meinRechteck:\nA = %f\nB = %f\nUmfang = %f\nFlaeche = %f\nDiagonale = %f",a, b, um_recht, fl_recht, dia_recht );

    return 0;
}

