/******************************************************************************
C++ Kurs BULME 19/20 SM
Datei 02

- Vererbung einer Basisklasse an abgeleitete Klassen
******************************************************************************/

#include <stdio.h>
#include <math.h>


namespace Planner
{
    enum corners { no, yes };
    
    
    // ---------------------> MainClass Form <--------------------- //
    
    class Form
    {                
      // protected  -->  Variables can also be used on inherited classes  
      protected:          
        corners m_corner;
        float m_scope;
        float m_surface;
     
      // public  -->  These mathods do not have to be repeated for inherited classes
      public:
        float GetScope();
        float GetSurface();
        unsigned char GetCornerEnum();
    
        Form(corners cornerEnum);
    };
    
    Form::Form(corners cornerEnum) 
    {
        m_corner = cornerEnum;
        m_scope = 0;
        m_surface = 0;
    };
    
    float         Form::GetScope()        { return m_scope; }
    float         Form::GetSurface()      { return m_surface; }
    unsigned char Form::GetCornerEnum()   { return m_corner; }
    
    
    
    
    
    // ---------------------> Class Circle <--------------------- //
    
                class Circle : public Form 
                {
                  protected:
                    // Use the variables m_scope and m_surface from the basic-class Form
                    float m_radius;
                    
                  public:
                    // Use the mathods GetSquare(), GetSurface() and GetCornerEnum() 
                    // from the basic-class Form
                    float GetRadius();
                    Circle(float radius);
                };
                
                Circle::Circle(float radius) : Form(no) 
                { 
                    // Calculate and save to variables
                    m_scope = 2 * radius * M_PI;
                    m_surface = radius * radius * M_PI;
                    m_radius = radius;
                }
                float Circle::GetRadius()   {  return m_radius; }
    
    
    
    
    
    // ---------------------> Class Rectangle <--------------------- //
    
    class Rectangle : public Form
    {
      protected:
        float m_length;
        float m_width;
        float m_diagonal;
        
      public:
        // Use the mathods GetSquare(), GetSurface() and GetCornerEnum() 
        // from the basic-class Form
        float GetLength();
        float GetWidth();
        float GetDiagonal();
        
        Rectangle(float length, float width);
    };
    
    
    Rectangle::Rectangle(float length, float width) : Form(yes)
    {
        // Calculate and save to variables
        m_length = length;
        m_width = width;
        m_surface = m_length * m_width;
        m_scope = (m_length*2) + (m_width*2);
        m_diagonal = sqrt(pow(m_length, 2) + pow(m_width, 2));
    }
    float Rectangle::GetLength()   { return m_length; }
    float Rectangle::GetWidth()    { return m_width; }
    float Rectangle::GetDiagonal() { return m_diagonal; }
    
    
    
    
    // ---------------------> Class Square <--------------------- //
    
                class Square : public Rectangle
                {
                    protected:
                        // Use the variable m_length, m_diagonal from Rectangle
                        // All other variables will be automatical calculate 
                        // by the Rectangle class
                
                    public:
                        // Use all other mathods from Rectangle
                        Square(float length);
                };
                
                
                Square::Square(float length) : Rectangle(length, length)
                {
                    // Calculate and save to variables
                    m_length = length;
                    m_diagonal = sqrt(this->GetSurface() * 2);
                }
}



// ---------------------> MainClass <--------------------- //

int main()
{
    Planner::Circle circle(1);
    Planner::Rectangle rectangle(3, 4);
    Planner::Square square(5);
    
    printf("Alle Werte des Kreises:\n");
    printf("Umfang = %f\n", circle.GetScope());
    printf("Fläche = %f\n", circle.GetSurface());
    printf("Radius = %f\n", circle.GetRadius());
    printf("Hat Ecken? %s\n", circle.GetCornerEnum() == 0 ? "Nein" : "Ja");
    
    printf("\n");
    
    printf("Alle Werte des Rechteckes:\n");
    printf("Umfang = %f\n", rectangle.GetScope());
    printf("Fläche = %f\n", rectangle.GetSurface());
    printf("Länge = %f\n", rectangle.GetLength());
    printf("Breite = %f\n", rectangle.GetWidth());
    printf("Digionale = %f\n", rectangle.GetDiagonal());
    printf("Hat Ecken? %s\n", rectangle.GetCornerEnum() == 0 ? "Nein" : "Ja");
    
    printf("\n");
    
    printf("Alle Werte des Quadrates:\n");
    printf("Umfang = %f\n", square.GetScope());
    printf("Fläche = %f\n", square.GetSurface());
    printf("Länge = %f\n", square.GetLength());
    printf("Digionale = %f\n", square.GetDiagonal());
    printf("Hat Ecken? %s\n", square.GetCornerEnum() == 0 ? "Nein" : "Ja");
    
    return 0;
}