/******************************************************************************
C++ Kurs 1920 Klassen Objekte
Datei 01

Klassen mit private und public
*******************************************************************************/

#include <stdio.h>


namespace Planner
{
    enum eckig 
    { 
        nein, 
        ja
    };
    
    
    class Kreis
    {
      // Keinen Zugriff nach außen
      private:
        // Verwendeten member-Variabeln in dieser Klasse
        float m_radius;
        eckig m_hat_ecken;
        float m_umfang;
        float m_flaeche;
        
        // Berechnet Umfang und Fläche und schreibt es in den member-Variabeln
        void Berechne();
      
      
      // Zugriff nach außen möglich
      public:
        // Methoden  -->  reine Ausgabe der member-Variabeln
        float leseUmfang();
        float leseFlaeche();
        unsigned char IstEckig();
    
        // Konstruktor  -->  zum definieren des enums und dem radius
        Kreis(enum eckig istEckig);
        Kreis(float radius);
        Kreis();
    };
    
    
    void Kreis::Berechne()
    {
        if (m_radius != 0)
        {
            m_flaeche = (m_radius * m_radius * 3.1415);
            m_umfang = (m_radius * 2 * 3.1415);
        }
        else
        {
            m_flaeche = 0;
            m_umfang = 0;
        }
    }



    // Konstruktor - Teile
    Kreis::Kreis(eckig istEckig)
    {
      m_radius = 0;
      m_hat_ecken = istEckig;
      Berechne();
    }
    
    Kreis::Kreis(float radius) 
    {
      m_radius = radius;
      m_hat_ecken = nein;
      Berechne();
    }
    
    Kreis::Kreis() 
    {
      m_radius = 0;
      m_hat_ecken = nein;
      Berechne();
    }
    
    
    
    // Für die Ausgabe nach außen
    float Kreis::leseFlaeche()  { return m_flaeche; }
    float Kreis::leseUmfang()   { return m_umfang; }
    unsigned char Kreis::IstEckig() { return m_hat_ecken; }
}


using namespace Planner;


int main ()
{
  Kreis meineForm(ja);
  Kreis meinKreis(1.0);
  
  printf ("Die Fläche des Kreises beträgt: %f\n", meinKreis.leseFlaeche());
  printf ("Der Umfang des Kreises beträgt: %f\n", meinKreis.leseUmfang());
  printf("Hat meineForm ecken?\t%s\n", (meineForm.IstEckig() == 1) ? "Ja" : "Nein");
  printf("Hat meineKreis ecken?\t%s", (meinKreis.IstEckig() == 1) ? "Ja" : "Nein");
  
  return 0;
}