/******************************************************************************

    1. Ergänzen Sie die Klasse Kreis um die Methode float leseFlaeche();
   
    2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
      
    3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.

*******************************************************************************/
#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

class Rechteck : public Form {      // 2. Aufgabe
    
    
    public:
     float leseUmfang();
     float leseFlaeche();
    
    Rechteck(float laenge, float breite);
};

Rechteck::Rechteck(float laenge, float breite) : Form(ja) {     // 2. Aufgabe
    
    m_umfang = 2 * (laenge + breite);
    m_flaeche = laenge * breite;
};
float Rechteck::leseUmfang() {
                                    // 2. Aufgabe
    return m_umfang; 
};

float Rechteck::leseFlaeche() {     
                                // 2. Aufgabe
    return m_flaeche;
};

class Quadrat : public Rechteck {       // 3. Aufgabe
  
  
    public:
    Quadrat(float seitelaenge);
};
Quadrat::Quadrat(float seitelaenge) : Rechteck(seitelaenge, seitelaenge) {    // 3. Aufgabe
    
};


class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
    
  public:                   
    float leseUmfang(); 
    float leseFlaeche();       // 1. Aufgabe, die Methode
    
    Kreis(float radius);    // Neuer Konstruktor erfordert nur den radius
    
};

Kreis::Kreis(float radius) : Form(nein) {
    // Im Konstruktor werden gleich die Membervariablen initialisiert
    
    // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};

float Kreis::leseUmfang() {
                                // hier ist keine Änderung der Funktion nötig,
                                // daher wird die Funktion der Basisklasse aufger.
    return m_umfang; 
}

float Kreis::leseFlaeche() {    // Methode mit Präfix Kreis:: regelt die Zugehörigkeit zur Klasse
                                // 1. Aufgabe
    return m_flaeche;
}


int main()
{
    
    Kreis kr(10.0);
    Rechteck rec(5.0, 4.0);
    Quadrat quad(3.0);
    
    float kreisFl = kr.leseFlaeche();           // 1. Aufgabe
    float rechteckUm = rec.leseUmfang();        // 2. Aufgabe
    float rechteckFl = rec.leseFlaeche();       // 2.Aufgabe
    float quadratUm = quad.leseUmfang();        // 3. Aufgabe
    float quadratFl = quad.leseFlaeche();       // 3. Aufgabe
    
    printf("Der Fläche des Kreis beträgt: %.2f\n", kreisFl);
    printf("Der Fläche des Rechteck beträgt: %.2f\n", rechteckFl);
    printf("Der Umfang des Rechteck beträgt: %.2f\n", rechteckUm);
    printf("Der Fläche des Quadrat beträgt: %.2f\n", quadratFl);
    printf("Der Umfang des Quadrat beträgt: %.2f\n", quadratUm);
    
    return 0;
}