/******************************************************************************

C++ Kurs BULME 19/20 SM
Aufgane 02
Vererbung
Mario Neubauer

*******************************************************************************/

#include <stdio.h>
#include <math.h>

enum eckig { ja = 0, nein = 1 }; 

//---------------------------------------------------
// Basisklasse 


class Form          
{                   
                    
  protected:     //Variablen, welche Vererbt werden können, jedoch nicht öffentlich zugänglich sind     
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:       //Variablen, welche öffentlich zugänglich sind
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }
    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};


//---------------------------------------------------------
//Klasse Kreis


class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
    float m_radius;                        // Klassen ebenfalls zugreifen können.
    
  public:                   
    float leseUmfang(); //Für den Umfang
    float leseFlaeche(); //Für die Fläche
    int Ecken(); //Prüft, ob Ecken vorhanden sind
    Kreis(float radius); // Neuer Konstruktor erfordert nur den radius 
};

Kreis::Kreis(float radius) : Form(nein) {  
    
    m_umfang = 2 * radius * M_PI;  // Der Umfang wird berechnet
    m_flaeche = radius * radius * M_PI; //Die Fläche wird berechnet
};

float Kreis::leseUmfang() {return m_umfang; } //Der Wert vom Umfang wird zurückgegeben
float Kreis::leseFlaeche() { return m_flaeche;} //Der Wert von der Fläche wird zurückgegeben
int Kreis::Ecken() {return m_hat_ecken;} //Es wird zurückgegeben, ob Ecken vorhanden sind


//---------------------------------------------------------
// Klasse Rechteck


class Rechteck : public Form{  //Klasse Rechteck wird erzeugt und Klasse Form wird vererbt
    
  protected:
    float m_laenge; //Für die Länge
    float m_breite; //Für die Breite
    
  public:
    float leseUmfang(); //Für den Umfang
    float leseFlaeche(); //Für die Fläche
    int Ecken(); //Prüft, ob Ecken vorhanden sind
    Rechteck(float laenge, float breite); //Konstruktor, welcher länge und breite erfordert
};

Rechteck::Rechteck(float laenge, float breite) : Form(ja) {  //Die Membervariable wird initialisiert
    
    m_umfang = 2 * laenge + 2 * breite; //Der Umfang wird berechnet
    m_flaeche = laenge * breite; //Die Fläche wird berechnet
    
};

float Rechteck::leseUmfang() {return m_umfang;} //Der Wert vom Umfang wird zurückgegeben
float Rechteck::leseFlaeche(){return m_flaeche;} //Der Wert von der Fläche wird zurückgegeben
int Rechteck::Ecken() {return m_hat_ecken;} //Es wird zurückgegeben, ob Ecken vorhanden sind


//--------------------------------------------------------------------
//Klasse Quadrat


class Quadrat : public Rechteck{  //Klasse Quadrat wird erzeugt und Klasse Rechteck wird vererbt
    protected:
    float m_laenge;  //Nur eine Länge nötig
    
    public:
    Quadrat(float laenge); //Nur die Länge ist erforderlich
};    

Quadrat::Quadrat(float laenge) : Rechteck(m_laenge, m_breite) { 
    m_umfang = laenge * 4;  //Der Umfang wird berechnet
    m_flaeche = laenge * laenge;  //Die Fläche wird berechnet
};


//--------------------------------------------------------------      
      //Hauptprogramm
      
      
int main()
{
    //Klassen werden initialisiert
    Kreis kr(1.0);
    Rechteck rt(4.0, 2.0);
    Quadrat qu(4.0);
    
    //--------------------------------------------------------------------------
    
    //Werte werden übernommen
    //Kreis
    int ecke_Kreis = kr.Ecken();
    float um_Kreis = kr.leseUmfang();
    float fl_Kreis = kr.leseFlaeche();
    
    //Rechteck
    int ecke_Rechteck = rt.Ecken();
    float um_Rechteck = rt.leseUmfang();
    float fl_Rechteck = rt.leseFlaeche();
    
    //Quadrat
    int ecke_Quadrat = qu.Ecken();
    float um_Quadrat = qu.leseUmfang();
    float fl_Quadrat = qu.leseFlaeche();
    
    //--------------------------------------------------------------------------
    
    
    //Werte werden ausgegeben
    //Kreis
    printf("Die Werte des Kreises:\n"); 
    printf("Der Umfang des Kreises beträgt: %f\n", um_Kreis); //Umfang
    printf("Die Fläche des Kreises beträgt: %f\n", fl_Kreis); //Fläche
    
    //Ausgabe Ecken
    switch(ecke_Kreis) {
    case 0: printf("Der Kreis hat Ecken\n\n"); break;
    default: printf("Der Kreis hat keine Ecken\n\n"); break;
    }
    
    //--------------------------------------------------------------------------
    
    //Rechteck 
    printf("Die Werte des Rechtecks:\n");
    printf("Der Umfang des Rechtecks beträgt: %f\n", um_Rechteck);
    printf("Die Fläche des Rechtecks beträgt: %f\n", fl_Rechteck);
    
    //Ausgabe Ecken
    switch(ecke_Rechteck) {
    case 0: printf("Das Rechteck hat Ecken\n\n"); break;
    default: printf("Das Rechteck hat keine Ecken\n\n"); break;
    }
    
    //--------------------------------------------------------------------------
    
    //Quadrat
    printf("Die Werte des Quadrats:\n");
    printf("Der Umfang des Quadrats beträgt: %f\n", um_Quadrat);
    printf("Die Fläche des Quadrats beträgt: %f\n", fl_Quadrat);
    
    //Ausgabe Ecken
    switch(ecke_Quadrat) {
    case 0: printf("Das Quadrat hat Ecken\n\n"); break;
    default: printf("Das Quadrat hat keine Ecken\n\n"); break;
    }
    return 0;
}
