#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
    {                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
    float m_rechteckFlaeche;
    float m_rechteckUmfang;

  
 
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }
    float leseRechteckUmfang() { return m_rechteckUmfang; }
    float leseRechteckFlaeche() { return m_rechteckFlaeche; }
 
  

    Form(eckig hat_ecken);
    Form();
    };

Form::Form(eckig ecken) // im Konstruktor werden gem. Variablen initialisiert
    {   
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
    };
Form::Form()
    {
    m_rechteckFlaeche=0;
    m_rechteckUmfang=0;
    }

class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
                            // Klassen ebenfalls zugreifen können.
    float m_radius;
    
  public:                   // alle gemeinsame Methoden
    float leseUmfang();
    float leseFlaeche();
    
    Kreis(float radius);  // Neuer Konstruktor erfordert nur den radius 
    };

Kreis::Kreis(float radius) : Form(nein) // Konstruktor
    { 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
    };

    float Kreis::leseUmfang() {// hier ist keine Änderung der Funktion nötig,
                            // daher wird die Funktion der Basisklasse aufger.
    return m_umfang; 
    }
    float Kreis::leseFlaeche() 
    {
    return m_flaeche; 
    }


class Rechteck : public Form { 
    
  protected:               
    float m_seiteA;
    float m_seiteB;
    float m_seitea;
    float m_quadratUmfang;
    float m_quadratFlaeche;
 
    
  public:                   
    float leseRechteckFlaeche();   // alle gemeinsame Methoden
    float leseRechteckUmfang();
    float leseQuadratUmfang() { return m_quadratUmfang; }
    float leseQuadratFlaeche() { return m_quadratFlaeche; }

    
    Rechteck(float seiteA, float seiteB); // Deklaration des Konstruktors
    Rechteck();                          // Deklaration des Konstruktors

    };

 
Rechteck::Rechteck(float seiteA,float seiteB) : Form(ja)  // Konstruktor
    {
    m_rechteckUmfang = 2 * seiteA + 2 * seiteB;  
    m_rechteckFlaeche = seiteA * seiteB;
    };

Rechteck::Rechteck()   // Konstruktor
    {
    m_quadratUmfang=0;
    m_quadratFlaeche=0;
    };

    float Rechteck::leseRechteckUmfang()
    {
    return m_rechteckUmfang; 
    }
    float Rechteck::leseRechteckFlaeche() 
    {
    return m_rechteckFlaeche; 
    }
    
    



class Quadrat : public Rechteck   //Deklaration der Klasse Quadrat
    
    {
    protected:               
    float m_seitea;
 
    public:                   
    float leseQuadratUmfang();
    float leseQuadratFlaeche();
    
    Quadrat(float seitea); // Deklaration des Konstruktors
    
    };

Quadrat::Quadrat(float seitea) : Rechteck() // Konstruktor
    {
    m_quadratFlaeche=seitea*seitea;
    m_quadratUmfang= 4 * seitea;
    };

  
    float Quadrat::leseQuadratUmfang()
    {
    return m_quadratUmfang; 
    }
    float Quadrat::leseQuadratFlaeche() 
    {
    return m_quadratFlaeche; 
    }





int main()
{
    printf("Wir arbeiten nun mit abgeleiteten Klassen!\n");
    printf("Nun wird ein Objekt kr der Klasse Kreis erzeugt!\n");
    Kreis kr(1.0);
    Rechteck re(2.0,3.0);
    Quadrat qu(5.0);
    
    float um = kr.leseUmfang();
    float fl = kr.leseFlaeche();
    
    float reUm = re.leseRechteckUmfang();
    float reFl = re.leseRechteckFlaeche();
    
    float quUm = qu.leseQuadratUmfang();
    float quFl = qu.leseQuadratFlaeche();
    
    printf("Der Umfang des Kreis beträgt: %f\n", um);
    printf("Die Flaeche des Kreis beträgt: %f\n", fl);
    
    printf("Der Umfang des Rechtecks beträgt: %f\n", reUm);
    printf("Die Flaeche des Rechtecks beträgt: %f\n", reFl);
    
    printf("Der Umfang des Quadrats beträgt: %f\n", quUm);
    printf("Die Flaeche des Quadrats beträgt: %f\n", quFl);
    return 0;
}




