/******************************************************************************

C++ Kurs BULME 19/20 SM
Datei 04

- Vererbung einer Basisklasse an abgeleitete Klassen

Eine Klasse kann als die Basis für die Entwicklung einer neuen Klasse verwendet 
werden, ohne dass ihr Code geändert werden muss. Dazu wird die neue Klasse 
definiert, indem angegeben wird, dass sie eine abgeleitete Klasse der 
Basisklasse ist. 

Während es in der letzten Lektion um den Aspekt der Kapselung gegangen ist,
geht es hier um den Aspekt der Vererbung. 

*******************************************************************************/
#include <stdio.h>
#include <math.h>

enum eckig { ja, nein };

class Form          // Basisklasse 
{                   
                    // In der Basisklasse werden alle gemeinsamen Variablen
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
 
  public:                   // sowie auch alle gemeinsamen Methoden deklariert
    float leseUmfang() { return m_umfang; }
    float leseFlaeche() { return m_flaeche; }

    Form(eckig hat_ecken);
};

Form::Form(eckig ecken) {   // im Konstruktor werden gem. Variablen initialisiert
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};

class Kreis : public Form { // Hier wird eine von Form abgeleitete Klasse Kreis deklariert
    
  protected:                // Zugriffschutz protected bedeutet, dass abgeleitete 
                            // Klassen ebenfalls zugreifen können.
    float m_radius;
    
  public:                   
    float leseUmfang();
    float leseFlaeche();
    
    Kreis(float radius);    // Neuer Konstruktor erfordert nur den radius 
};


class Rechteck : public Form { 
    
  protected:     
    float seite_a;
    float seite_b;
    
  public:                   
    float leseUmfang();
    float leseFlaeche();
    
    Rechteck(float a, float b);    
};

Rechteck::Rechteck(float a, float b) : Form(ja) {
    seite_a = a;
    seite_b = b;
    
    m_umfang = (2*a) + (2*b);   
    m_flaeche = a*b;
};


Kreis::Kreis(float radius) : Form(nein) {
    // Im Konstruktor werden gleich die Membervariablen initialisiert
    
    // Über den radius werden Umfang und Fläche berechnet. 
    m_umfang = 2 * radius * M_PI;  // Die Konstante M_PI ist in math.h definiert
    m_flaeche = radius * radius * M_PI;
};

float Kreis::leseUmfang() {
                                // hier ist keine Änderung der Funktion nötig,
                                // daher wird die Funktion der Basisklasse aufger.
    return m_umfang; 
}

float Kreis::leseFlaeche(){
    return m_flaeche;
}

float Rechteck::leseFlaeche(){
    return m_flaeche;
}

float Rechteck::leseUmfang(){
    return m_umfang;
}

/* Ihre Aufgaben!
   1. Ergänzen Sie die Klasse Kreis um die Methode float leseFlaeche();
   
   2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Überlegen Sie sich welche Parameter der Konstruktur für die Klasse
      Rechteck benötigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
      
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.
      
      Format der Dateinamen: <Nachname>_<Übungsnummer>_<Titel>
      Bsp: Brunnhofer_2_Vererbung
      
      Hinweis: Der Quellcode der Programme sollte auch kommentiert werden!
      
*/

int main()
{
    printf("Wir arbeiten nun mit abgeleiteten Klassen!\n");
    printf("Nun wird ein Objekt kr der Klasse Kreis erzeugt!\n");
    Kreis kr(1.0);
    Rechteck re(4.0, 5.5);
    
    float um = kr.leseUmfang();
    
    float flaeche = re.leseFlaeche();
    float umfang = re.leseUmfang();
    
    printf("Der Umfang des Kreis beträgt: %f\n", um);
    printf("Die Flaeche des Rechtecks beträgt: %f\n", flaeche);
    printf("Der Umfang des Rechtecks beträgt: %f\n", umfang);
    return 0;
}

/*
  Weiterführende Links:
  https://os.mbed.com/users/fpucher/code/HIM0Board/wiki/Vererbung-in-C++
  https://de.wikibooks.org/wiki/C%2B%2B-Programmierung:_Vererbun
*/


