#include <stdio.h>
#include <math.h>
 
enum eckig { ja, nein };
 
class Form          
{                   
                    
  protected:          
    eckig m_hat_ecken;
    float m_umfang;
    float m_flaeche;
  
  public:                   
    float leseUmfang() 
    { 
        return m_umfang;
    };
    float leseFlaeche() 
    { 
        return m_flaeche;
        
    };
 
    Form(eckig hat_ecken); 
};
 
Form::Form(eckig ecken) 
{   
    m_hat_ecken = ecken;
    m_umfang = 0;
    m_flaeche = 0;
};
 
 //Kreis
class Kreis : public Form 
{ 
    
  protected:                 
    float m_radius;           
 
  public:                   
    Kreis(float radius);   
};
 
Kreis::Kreis(float radius) : Form(nein)
{

    m_umfang = 2 * radius * M_PI;  
    m_flaeche = radius * radius * M_PI;
};
 
 
//Rechteck
class Rechteck : public Form {
    
    protected:
    float m_seiteA;
    float m_seiteB;
    
    public:
    Rechteck(float seiteA,float seiteB);
    float lese_seiteA();
    float lese_seiteB();
};
 
Rechteck::Rechteck(float seiteA,float seiteB) : Form(ja)
{
    m_seiteA=seiteA;
    m_seiteB=seiteB;
    m_umfang = 2*seiteA+2*seiteB;
    m_flaeche = seiteA * seiteB;
};
 
float Rechteck::lese_seiteA()
{
    return m_seiteA;
}
 
float Rechteck::lese_seiteB()
{
    return m_seiteB;
}
 
 
int main()
{
    
    Kreis kr(1.0);
    float um = kr.leseUmfang();
    printf("\nDer Umfang des Kreis beträgt: %0.2f\n", um);
    float fl=kr.leseFlaeche();
    printf("Die Flaeche des Kreis beträgt: %0.2f\n", fl);
    
    
    Rechteck re(1.0,2.0);
 
    printf("Der Umfang des Rechtecks beträgt: %0.2f\n", re.leseUmfang());
    printf("Die Flaeche des Rechtecks beträgt: %0.2f\n", re.leseFlaeche());
    
    
    return 0;
}