#include <iostream>

class Player {
private:
    int points;
public:
    int getPoints() const {
        return points;
    }

    void setPoints(int points) {
        Player::points = points;
    }

    void addPoints(int points){
        Player::points += points;
    }

    void subtractPoints(int points){
        Player::points -= points;
    }

    int getGuess() {
        std::cout << "Guess a number between 0 and 9: ";
        int guess;
        while (1) {
            std::cin >> guess;
            if (guess >= 0 && guess <= 9) {
                return guess;
            } else {
                std::cout << "Your guess must be a number between 0 and 9" << std::endl;
            }
        }
    }

    int getBet() {
        std::cout << "Your total Points are: " << Player::points << std::endl;
        std::cout << "Choose your Bet: ";
        int bet;
        while (1) {
            std::cin >> bet;
            if (bet >= 1 && bet <= Player::points) {
                return bet;
            } else {
                std::cout << "Your bet must be a number between 1 and your total Points" << std::endl;
            }
        }
    }

};


class Game {
private:
    Player player;
    int num_to_guess;
public:
    const Player &getPlayer() const {
        return player;
    }

    void setPlayer(const Player &player) {
        Game::player = player;
    }

    int getNumToGuess() const {
        return num_to_guess;
    }

    void setNumToGuess(int numToGuess) {
        num_to_guess = numToGuess;
    }

};


int main() {
    bool run = true;
    std::cout << "New Game!" << std::endl;
    Game game;
    Player player;
    player.setPoints(10000);
    game.setPlayer(player);
    while(run){
        game.setNumToGuess(rand() % 9 + 1);
        int invested_points = player.getBet();
        if (game.getNumToGuess() == player.getGuess()) {
            std::cout << "The number to guess was: " << game.getNumToGuess() << std::endl;
            int points_won = invested_points * 9;
            player.addPoints(points_won);
            std::cout << "You won " << points_won << " points!" << std::endl;
            std::cout << "You total score is now: " << player.getPoints() << " points!" << std::endl;
        }
        else{
            std::cout << "The number to guess was: " << game.getNumToGuess() << std::endl;
            player.subtractPoints(invested_points);
            std::cout << "You lost " << invested_points << " points!" << std::endl;
            std::cout << "You total score is now: " << player.getPoints() << " points!" << std::endl;
        }
        std::cout << "Do you want to play again? (Y/N) " << std::endl;
        char again;
        std::cin >> again;
        if (again == 'n' || again == 'N') {
            run = false;
        } else if (again == 'y' || again == 'Y'){
            std::cout << "Another round!" << std::endl;
        }
    }
    std::cout << "Game ended! Bye Bye" << std::endl;
    return 0;
}
