/******************************************************************************

C++ Course BULME 19/20 SM

Inheritence of a baseclass to inherited classes

*******************************************************************************/
#include <stdio.h>
#include <math.h>

enum angular
{ yes, no };

class Shape
{
protected: //protected members can be accessed by inherited classes but not from outside
  angular m_has_corners;

public:
    //by defining pure virtual functions we make the class abstract
    //abstract classes cannot be instanciated
  virtual float getPerimeter() = 0; //a pure virtual function has to be implemented by derived classes
  virtual float getArea() = 0;

  Shape (angular has_corners);
};

Shape::Shape (angular has_corners)
{
  m_has_corners = has_corners;
};


//Class Circle is derived from class Shape
class Circle:public Shape
{
private:
  float m_radius;

public:
    Circle (float radius);
    float getRadius();
    float getPerimeter();
/*
   1. Ergaenzen Sie die Klasse Kreis um die Methode float leseFlaeche();
*/
    float getArea();
};

Circle::Circle (float radius):Shape (no)
{
    m_radius = radius;
};


float Circle::getRadius(){
    return m_radius;
}

float Circle::getPerimeter(){
    return 2 * m_radius * M_PI;
}

/*
   1. Ergaenzen Sie die Klasse Kreis um die Methode float leseFlaeche();
*/
float Circle::getArea(){
    return m_radius * m_radius * M_PI;
}


/*
   2. Leiten Sie von der Basisklasse Form die Klasse Rechteck ab
      Ueberlegen Sie sich welche Parameter der Konstruktur fuer die Klasse
      Rechteck benoetigt. Implementieren sie neben dem Konstruktor auch alle 
      Methoden der Basisklasse, sodass korrekte Werte berechnet werden.
*/
class Rectangle:public Shape //Class Rectangle is derived from class Shape
{
private:
  float m_length;
  float m_width;

public:
    Rectangle (float length, float height);
    float getLength();
    float getWidth();
    float getPerimeter();
    float getArea();
};

Rectangle::Rectangle (float length, float width):Shape (yes)
{
    m_length = length;
    m_width = width;
};

float Rectangle::getLength(){
    return m_length;
}


float Rectangle::getWidth(){
    return m_width;
}

float Rectangle::getPerimeter(){
    return 2 * m_length + 2 * m_width;
}

float Rectangle::getArea(){
    return m_length * m_width;
}


/*
   3. Optional: Leiten Sie von der Klasse Rechteck die Klasse Quadrat ab.
      Implementieren Sie Konstruktor und alle Methoden in der Form, dass 
      die Implementierungen der Klasse Rechteck genutzt werden.
      Quadrat soll eine Subklasse von Rechteck sein.
*/
class Square:public Rectangle //Class Square is derived from class Rectangle
{
public:
    Square (float length);
};

/*A Square has four equal sides, so we call the Rectangle constructor
and pass the same parameter for length and width*/
Square::Square (float length):Rectangle(length, length)
{
};

int
main ()
{
  printf ("Wir arbeiten nun mit abgeleiteten Klassen!\n\n");
  
  printf ("Nun wird ein Objekt der Klasse Circle erzeugt!\n");
  Circle circle1 (1.0);
  printf ("Der Radius des Kreises betraegt: %f\n", circle1.getRadius ());
  printf ("Der Umfang des Kreis betraegt: %f\n", circle1.getPerimeter ());
  printf ("Die Flaeche des Kreises betraegt: %f\n", circle1.getArea ());

  printf ("\nNun wird ein Objekt der Klasse Rectangle erzeugt!\n");
  Rectangle rectangle1 (1.0, 2.0);
  printf ("Die Laenge des Rechtecks betraegt: %f\n", rectangle1.getLength());
  printf ("Die Breite des Rechtecks betraegt: %f\n", rectangle1.getWidth());
  printf ("Der Umfang des Rechtecks betraegt: %f\n", rectangle1.getPerimeter());
  printf ("Die Flaeche des Rechtecks betraegt: %f\n", rectangle1.getArea());


  printf ("\nNun wird ein Objekt der Klasse Square erzeugt!\n");
  Square square1 (2.0);
  printf ("Die Laenge des Quadrats betraegt: %f\n", square1.getLength());
  printf ("Die Breite des Quadrats betraegt: %f\n", square1.getWidth());
  printf ("Der Umfang des Quadrats betraegt: %f\n", square1.getPerimeter());
  printf ("Die Flaeche des Quadrats betraegt: %f\n", square1.getArea());
  return 0;
}